/***************************************************************************
                          enumvalue.h  -  description                              
                             -------------------                                         
    begin                : Fri Mar 19 1999                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef ENUMVALUE_H
#define ENUMVALUE_H

#include <qstring.h>
#include <qstrlist.h>
#include <qlist.h>
#include "value.h"

/**
	* Represents a enum value.
	*
  * @author Richard Moore
  */
class EnumValue : public Value  {
public: 
	EnumValue();
	virtual ~EnumValue();

	virtual ValueEditor *createEditor(QWidget *);

	/**
		* Convert the value to a string.
		*/
	virtual const char *toString();

	/**
		* Set the value from a string.
		*/
	virtual void fromString(const char *);
	
	/**
		* Convert the value to an int.
		*/
	virtual int toInt();
	
	/**
		* Return the selected index.
		*/
	int index();
	
	/**
		* Set the selected index to v.
		*/
	void setIndex(int v);

	/**
		* Add another entry to the Enum.
		*/
	virtual void addValue(const char *name, int value);

	/**
		* Returns the names used for this Enum.
		*/
	const QStrList *valueNames();
		
protected:
	int selectedIndex;
	QStrList valueNames_;
	QList <int> values_;
};

#endif





