/***************************************************************************
                          kguidoc.cpp  -  description                              
                             -------------------                                         
    begin                : Mon Mar 15 23:42:04 GMT 1999
                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include <kguidoc.h>
#include <qtabdialog.h>
#include "global.h"
#include "component.h"
#include "propertydialog.h"
#include "propertytree.h"

KGUIDoc::KGUIDoc(QObject *parent, const char *filename)
	:	QObject(parent)
{
	selection_= 0;

	ComponentManager *cm= Global::getComponentManager();

	toplevel= cm->package(0)->component(0)->createInstance(0);
	toplevel->setName("Top level Form");
	
	// Add some kids
	Instance *ins= cm->package(0)->component(1)->createInstance(toplevel);
	ins->setName("Label child 1");

	Instance *ins2= cm->package(0)->component(1)->createInstance(toplevel);
	ins2->setName("Label child 2");
}

KGUIDoc::~KGUIDoc()
{
	delete toplevel;
}

Instance *KGUIDoc::rootInstance()
{
	return toplevel;
}

void KGUIDoc::refreshViews(Instance *root)
{
	if (!root)
		emit update(toplevel);
	else {
		emit update(root);
		emit update();
	}
}

void KGUIDoc::remove(Instance *parent, int n)
{
	warning("Document remove(%p, %d)", parent, n);

	Instance *child= parent->getChild(n);
	if (selection_ == child) {
		selection_= 0;
	}
	
	parent->removeChild(n);
	
	emit update(parent);
	emit update();
}

void KGUIDoc::swap(Instance *parent, int m, int n)
{
	warning("Document swap(%p, %d, %d)", parent, m, n);
	
	emit update(parent);
	emit update();
}

bool KGUIDoc::insert(Component *c)
{
	ASSERT(c);

	warning("KGUIDoc::insert() %s", c->name());

	if (selection_) {
		Instance *child= c->createInstance(selection_);
		if (child) {
			child->setName("new instance");
			
			emit update(selection_);
			emit update();
			
			return true;
		}
	}
	else {
		warning("No parent selected");
	}
	
	return false;
}

// SLOT
void KGUIDoc::select(Instance *i)
{
	selection_= i;
}


























