/***************************************************************************
                          package.h  -  description                              
                             -------------------                                         
    begin                : Sat Mar 20 1999                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef PACKAGE_H
#define PACKAGE_H

#include <qlist.h>
#include <qstring.h>
#include <qpixmap.h>
#include "component.h"

/**
	* Represents a Package of Components.
	*
  * @author Richard Moore
  */
class Package {
public: 
	/**
		* Create a package.
		* @param name The name of the package (as seen by the user)
		* @param desc The description of the package (short)
		* @param helpURL The URL for help on this package.
		*/
	Package(const char *name, const char *desc, const char *helpURL= 0);
	virtual ~Package();

	/**
		* Return the name of the Package.
		*/
	const char *name();
	
	/**
		* Return the description of the Package.
		*/
	const char *description();
	
	/**
		* Return the URL for help on this package. If the URL is relative,
		* then it is taken relative to the packages subdirectory of the
		* kgui documentation tree.
		*/
	virtual const char *helpURL();
	
	/**
		* Pixmap to be used for this package in the tree view (and
		* also elsewhere). You should override this to return a custom
		* pixmap.
		*/
	virtual QPixmap pixmap();

	/**
		* Add a component to the package
	 	*/
	void addComponent(Component *);
	uint componentCount();
	Component *component(uint n);

private:
	QString name_;
	QString desc_;
	QString helpURL_;
	QList <Component> components;
};

#endif







