// -*- c++ -*-

#ifndef PLUGINLOADER_H
#define PLUGINLOADER_H

class ComponentManager;

/**
 * Class responsible for loading plugins and registering them with
 * the ComponentManager.
 *
 * @author Richard Moore rich@kde.org
 */
class PluginLoader
{
public:
   /**
    * Install plugins to the specified ComponentManager.
    */
   static void install(ComponentManager *cm);

   /**
    * Install all plugins in the specified dir.
    */
   static void installDir(ComponentManager *cm, const char *dirname);

   /**
    * Install the plugin at the specified path in the ComponentManager.
    *
    * @return true if successfull
    */
   static bool installPlugin(ComponentManager *cm, const char *path);
};

#endif // PLUGINLOADER_H

