%{

/*************************************************************
*
* (c) 1999, 2000 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

int cfgsection = 0;
int freevar = 0;

extern int yylineno;
int rlines = 0;

char *vkc, *in, *out;
char *f_name = 0L;
char *wfv;

void add_word( int, char *, char * );
void add_dword( int, char *, char *, char * );
int lookup_word( int, char * );
int strxcmp( char *, char * );
void fputl( char * );
void getvar( char ** );

extern FILE *yyin, *yyout;
%}

%union
{
	char *str;
}

%token <str>HEAD VAR VARO FUNCTION OBJECT PROPERTY CINT CFLOAT CSTRING CBOOL
%token <str>OPERATOR IF THEN ELSE FOR TO WHILE DO

%type <str>cfgval codeblock inblock statement returnunit basics varlist
%type <str>var expression exprelement parexpression minexpression function
%type <str>object expressionlist const

%%

all: config { printf( "Configuration has been read.\n" );  }
	| code { printf( "Output file (out) generated.\n" ); exit(0); }
	;

/* Config parsing: */

config: cfgpart
	| config cfgpart
	;

cfgpart: cfgblock '#' { cfgsection++; }
	| var '#' { cfgsection++; }
	| '#' { cfgsection++; }
	;

cfgblock: cfgdec
	| cfgblock cfgdec
	;

cfgdec: var cfgval {

			switch(cfgsection)
			{
				case 1: /* Consts */
					add_word( 1, $1, $2 );
					break;

				case 2: /* Variables */
					add_word( 2, $1, $2 );
					break;

				case 3: /* Functions */
					add_word( 3, $1, $2 );
					break;

				case 5: /* Widgets */
				#define wnameWarning "/*WARNING: local widgets .* are unknown, as\
					the vkc file doesn't contain the absolute name\
					of the (actual) window, yet !!!*/\n"

					add_dword( 5, $2, "", $1 );
						/* "" should be the relative (local) widget name */
					break;
			}
		};

cfgval: VAR
	| const
	| object
	;

/* Code parsing: */

code: HEAD '(' { fputl( $1 ); fputc( '(', yyout ); }
	  expressionlist ')' { fputl( $4 ); fputs( ")\n", yyout ); } codeblock
	| HEAD '(' ')' { fputl( $1 ); fputc( '(', yyout ); fputs( ")\n", yyout ); }
	  codeblock
	;

codeblock: '{' '}' { fputl( "{\n}\n" ); }
	| '{' { fputl( "{\n" ); } inblock '}'
		{
			fputc( '}', yyout );
			fputc( '\n', yyout );
		};

inblock:  statement
	| codeblock
	| inblock statement
	| inblock codeblock
	;

statement:  returnunit '=' expression
		{
			fputl( $1 );
			fputc( '=', yyout );

			fputl( $3 );

		} ';' { fputc( '\n', yyout ); }
	| function { fputl( $1 ); } ';' { fputc( '\n', yyout ); }
	| basics { fputl( $1 ); fputl( "\n{\n" ); } statement { fputl( "}\n" ); }
	| basics { fputl( $1 ); fputc( '\n', yyout ); } codeblock
	;

returnunit: var { $$ = $1; }
	| '(' varlist ')'
		{
			$$ = malloc( sizeof(char) *(strlen($2)+3) );
			strcpy( $$, "(" );
			strcat( $$, $2 );
			strcat( $$, ")" );
		};

basics: IF expression THEN
		{
			$$ = malloc( sizeof(char) *(strlen($2)+5) );

			strcpy( $$, "if(" );
			strcat( $$, $2 );
			strcat( $$, ")" );
		}
	| ELSE
		{
			$$ = malloc( sizeof(char) *7 );

			strcpy( $$, "else()" );

		}
	| FOR var '=' expression TO minexpression DO
		{

			$$ = malloc( sizeof(char) *(strlen($2)+strlen($4)+strlen($6)+14) );

			strcpy( $$, "for " );
			strcat( $$, $2 );
			strcat( $$, "=" );
			strcat( $$, $4 );
			strcat( $$, " to " );
			strcat( $$, $6 );
			strcat( $$, " do" );
		}
	| WHILE {
			getvar(&wfv);

			fputc( '', yyout );
			fputl(wfv);
			fputc( '', yyout );
			fputc( '\n', yyout );

		}
		expression DO
		{
			$$ = malloc( sizeof(char) *(strlen(wfv)+strlen($3)+9) );

			strcpy( $$, "while(" );
			strcat( $$, $3 );
			strcat( $$, " " );
			strcat( $$, wfv );
			strcat( $$, ")" );
		};

varlist: var { $$ = $1; }
	| varlist ',' var
		{
			$$ = malloc( sizeof(char) *(strlen($1)+strlen($3)+2) );

			strcpy( $$, $1 );
			strcat( $$, "," );
			strcat( $$, $3 );
		};

var: VAR { $$ = $1; }
	| VARO { $$ = $1; }
	| PROPERTY '@' object
		{
			$$ = malloc( sizeof(char) *(strlen($1)+strlen($3)+2) );
			strcpy( $$, $3 );
			strcat( $$, ":" );
			strcat( $$, $1 );
		};

expression: exprelement { $$ = $1; }
	| expression OPERATOR exprelement
		{
		char *fv;

			getvar(&fv);
			fputl(fv);
			fputl("=");
			fputl( $1 );
			fputl( $2 );
			fputl( $3 );
			fputl( "\n" );
			$$ = fv;
		}
        ;

exprelement: minexpression { $$ = $1; }
	| parexpression { $$ = $1; }
	;

parexpression: '(' expression ')' { $$ = $2; };

minexpression: var { $$ = $1; } | function { $$ = $1; } | const { $$ = $1; };

function: FUNCTION '(' ')' {
			$$ = malloc( sizeof(char) *(strlen($1)+3) );
			strcpy( $$, $1 );
			strcat( $$, "()" );
		}
	| FUNCTION '(' expressionlist ')'
		{
			$$ = malloc( sizeof(char) *(strlen($1)+strlen($3)+3) );
			strcpy( $$, $1 );
			strcat( $$, "(" );
			strcat( $$, $3 );
			strcat( $$, ")" );
		};

object: OBJECT { $$ = $1; } | VARO { $$ = $1; }
	;

expressionlist: expression
	| expressionlist ',' expression
		{
			$$ = malloc( sizeof(char) *(strlen($1)+strlen($3)+2) );

			strcpy( $$, $1 );
			strcat( $$, "," );
			strcat( $$, $3 );
		};

const: CINT { $$ = $1; } | CFLOAT { $$ = $1; } | CSTRING { $$ = $1; } | CBOOL { $$ = $1; };

%%

main( int argc, char **argv )
{

	for( argc--; argc > 0; argc-- )
	{
		argv++;

		if( strcmp( argv[0] +sizeof(char)*( strlen(argv[0]) -4 ), ".vkc" ) == 0 )
		{
			if( vkc != 0L )
			{
				printf( "vkPreTranslator: ERROR 01: Several *.vkc files.\n" );
				exit(1);
			}
			vkc = argv[0];
		}
		else if( in == 0L )
			in = argv[0];
		else if( out == 0L )
			out = argv[0];
		else
		{
			printf( "vkPreTranslator: ERROR 02: Too many arguments.\n" );
			exit(1);
		}
	}

	if( vkc == 0L || in == 0L || out == 0L )
	{
		printf( "vkPreTranslator: ERROR 02: Too few arguments.\n" );
		exit(1);
	}

	yyin = fopen( vkc, "r" );
	yyout = fopen( out, "w" );

	f_name = vkc;

	yyparse(); /* Parsing config file; yyparse for input code is called
			again from the lexer */
}

yyerror(char *s)
{
	printf( "vkPreTranslator: in file %s (line %d): syntax error\n",
		f_name, yylineno-rlines+1 );
	exit(1);
}


struct word
{
	char *entry;
	char *entry2;
	char *type_text;
	int type;
	struct word *next;
};

struct word *wlist = 0L;

void add_word( int type, char *new_word, char *new_word2 )
{
struct word *w;

	w = (struct word *) malloc( sizeof(struct word) );

	w->next = wlist;

	w->entry = (char *) malloc( sizeof(char) *(strlen(new_word)+1) );
	strcpy(w->entry, new_word);
	w->entry2 = (char *) malloc( sizeof(char) *(strlen(new_word2)+1) );
	strcpy(w->entry2, new_word2);
	w->type_text = (char *) malloc( sizeof(char) );
	w->type_text[0] = 0L;
	w->type = type;
	wlist = w;

}

void add_dword( int type, char *new_word, char *new_word2, char *new_tinfo )
{
	add_word( type, new_word, new_word2 );
	free(wlist->type_text);
	wlist->type_text = (char *) malloc( (strlen(new_tinfo)+1)*sizeof(char) );
	strcpy( wlist->type_text, new_tinfo );
	
}

void fputl( char *pstring )
{
char *pscp;
int i;
int strMode = 0;

	pscp = (char *) malloc( sizeof(char) *(strlen(pstring)+1) );
	strcpy( pscp, pstring );


	for( i = 0; pscp[i] != 0L; i++ )
	{
		if( pscp[i] == '"' ) strMode = !strMode;

		if (!strMode) pscp[i] = tolower(pscp[i]);
	}

	fputs( pscp, yyout );

	free(pscp);
}


int strxcmp( char *w1, char *w2 )
{
int i;

	for( i = 1; w1[i] != 0L; i++ )
	{
		if( w2[i] == 0L ) return 1;

		if( tolower( w1[i] ) != tolower( w2[i] ) ) return -1;
	}

	if( w2[i] != 0L )
		return 2;
	else
		return 0;

}

int lookup_word( int type, char *lookupword )
{
struct word *w = wlist;

	while(w!=0L)
	{
		if( type == 3 )
		{

			if( (strxcmp(w->entry,lookupword) == 0
				|| strxcmp(w->entry2,lookupword) == 0 )
				&& w->type == 3 )
				return 1; /*Found*/
		}
		else
		{
			if( strxcmp(w->entry,lookupword) == 0
				&& w->type == type )
				return 1; /*Found*/
		}

		 w = w->next;
	}

	return 0; /* No such entry ... */
}

void getvar( char **dst )
{
int n, i, ii = 6;
char *dest;

	dest = (char *)malloc( sizeof(char) * 8 );

	strcpy( dest, "_000000" );
	n = freevar;

	for( i = 1; i <= 100000; i = i*10 )
	{
		dest[ii] = n % 10 +48;
		n = n/10;
		ii--;
	}

	freevar++;

	*dst = dest;
	
}