/*************************************************************
*
* (c) 1999, 2000 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

int sptr;

void eatWhite( char *scanstr )
{
int i = -1;

	while( i != sptr )
	{
		i = sptr;

		while( scanstr[sptr] == ' ' || scanstr[sptr] == '\t'
			|| scanstr[sptr] == '\n' )
			sptr++;

		if( scanstr[sptr] == '#' )
			while( scanstr[sptr] != '\n' ) sptr++;
	}

}

char *nextWord( char *scanstr, int eatWh )
{
int strMode = 0;
char *ret;

	ret = (char *) malloc( sizeof(char) );
	ret[0] = 0L;

	if(eatWh) eatWhite( scanstr );

	if( scanstr[sptr] == 0L ) return 0L;

	while( isalnum(scanstr[sptr]) || strMode || scanstr[sptr] == '"'
		|| scanstr[sptr] == '_' || scanstr[sptr] == '.' )
	{
		if( scanstr[sptr] == '"' ) strMode = !strMode;

		ret = realloc( ret, (strlen(ret)+2)*sizeof(char) );
		ret[strlen(ret)+1] = 0L;
		ret[strlen(ret)] = scanstr[sptr];
		sptr++;

	}

	if( strlen( ret ) == 0 )
	{ // Return at least one char

		ret = realloc( ret, (strlen(ret)+2)*sizeof(char) );
		ret[strlen(ret)+1] = 0L;
		ret[strlen(ret)] = scanstr[sptr];
		sptr++;
	}

	return ret;
}

void updateBase( char *fn )
{
FILE *fp, *fpd;
char *fc;
int i = 0;
char c = 0;
char *getR = " ";
int actualID = 0;
char udatet[21] = "";
char *tmpStr;

char *pname = 0L, *ver = 0L, *home = 0L, *author = 0L, *mail = 0L;
int prgroup = 0, prstability = -1;


	/* Job: Update ../configure.in, GNU files, ../program/Makefile.am;
	   Copy the program icons and generate *kdelnk file. */

	/* Read information in project.conf */

	sptr = 0;
	fc = malloc( sizeof(char) );
	fc[0] = 0L;

	fp = fopen( fn, "r" );

	while( (c = fgetc(fp)) != EOF )
	{
		fc = realloc( fc, (strlen(fc)+2)*sizeof(char) );
		fc[strlen(fc)+1] = 0L;
		fc[strlen(fc)] = c;
	}

	getR =  nextWord( fc, 1 ); /* Skip over "Project" */

	while( getR[ strlen(getR) -1 ] != ')' )
	{
		getR =  nextWord( fc, 1 );

		if( strlen(getR) > 1 )
		{ //Not a semicolon or another one-char separator ( '(' ')' '=' )

			if( getR[0] != '"' )
			{ //Identifier

				if( cmpLow( getR, "name" ) == 0 )
					actualID = 1;
				else if( cmpLow( getR, "version" ) == 0 )
					actualID = 2;
				else if( cmpLow( getR, "stable" ) == 0 )
					actualID = 3;
				else if( cmpLow( getR, "home" ) == 0 )
					actualID = 4;
				else if( cmpLow( getR, "author" ) == 0 )
					actualID = 5;
				else if( cmpLow( getR, "email" ) == 0 )
					actualID = 6;
				else if( cmpLow( getR, "group" ) == 0 )
					actualID = 7;
				else
				{
					printf( "vkProjectCreator: Unknown identifier %s in project.conf.\n", getR );
					exit(2);
				}
			}
			else
			{ //Value

				/* Skip over '"'s */
				getR[ strlen(getR) -1 ] = 0L;
				getR = getR +sizeof(char);

				switch( actualID )
				{
					case 1: /* name */
						for( i = 0; getR[i] != 0L; i++ )
							if( !isalpha(getR[i]) )
							{
								printf( "vkProjectCreator: Please use only " );
								printf( "alphabetic charactars in your project name!\n" );
								exit(2);
							}

						pname = getR;
						break;

					case 2: /* version */
						for( i = 0; getR[i] != 0L; i++ )
							if( !isdigit(getR[i]) && getR[i] != '.' )
							{
								printf( "vkProjectCreator: Please use only " );
								printf( "numeric charactars and points as version string!\n" );
								exit(2);
							}

						ver = getR;
						break;

					case 3: /* stable */
						if( cmpLow( getR, "true" ) != 0
							&& cmpLow( getR, "false" ) != 0 )
						{
							printf( "vkProjectCreator: Invalid " );
							printf( "information about stability!\n" );
							exit(2);
						}

						if( cmpLow( getR, "true" ) == 0 )
							prstability = 1;
						else
							prstability = 0;

						break;

					case 4: /* home */
						home = getR;
						break;

					case 5: /* author */
						author = getR;
						break;

					case 6: /* email */
						if( getR[0] != '<' || getR[strlen(getR)-1] != '>' )
						{
							printf( "vkProjectCreator: Please use the form " );
							printf( "<alias@domain> for your e-mail address!\n" );
							exit(2);
						}

						mail = getR;
						break;

					case 7: /* group */
						if( cmpLow( getR, "application" ) == 0 )
							prgroup = 1;
						else if( cmpLow( getR, "utility" ) == 0 )
							prgroup = 2;
						else if( cmpLow( getR, "game" ) == 0 )
							prgroup = 3;
						else
						{
							printf( "vkProjectCreator: Unknown program type " );
							printf( "(group) %s!\n", getR );
							exit(2);
						}

						break;

					default:
						printf( "vkProjectCreator: Invalid declaration in project.conf.\n", getR );
						exit(2);
				}
			}

		} /* if (...) */

	} /* while */

	free(fc);

	fclose(fp);

	/* Check information: */

	if( pname == 0L )
	{
		printf( "vkProjectCreator: No project name declared in project.conf\n" );
		exit(2);
	}

	if( ver == 0L )
	{
		printf( "vkProjectCreator: No version declared in project.conf\n" );
		exit(2);
	}

	if( home == 0L )
		home = "(none)";

	if( author == 0L )
	{
		printf( "vkProjectCreator: No author declared in project.conf\n" );
		exit(2);
	}

	if( mail == 0L )
	{
		printf( "vkProjectCreator: No author e-mail declared in project.conf\n" );
		exit(2);
	}

	if( prgroup == 0 )
	{
		printf( "vkProjectCreator: No group for the project declared in project.conf\n" );
		exit(2);
	}

	if( prstability == -1 )
	{
		printf( "vkProjectCreator: No information about stability in project.conf\n" );
		exit(2);
	}

	/* All checks OK, now generate files: */

	/* First try to get the date in user format from ./.today */
	fp = fopen( "./.today", "r" );
	if( fp != 0L )
	{
		fgets( udatet, 20, fp );
		fclose(fp);
	}

	/* GNU files: */
	fp = fopen( "../AUTHORS", "w" );
	fputs( author, fp );
	fputc( ' ', fp );
	fputs( mail, fp );
	fputc( '\n', fp );
	fclose(fp);

	fp = fopen( "../VERSION", "w" );
	fputc( 'v', fp );
	fputs( ver, fp );
	fputc( '\n', fp );
	fclose(fp);

	/* *.lsm: */
	tmpStr = malloc( ( strlen(pname) +strlen(ver) +9 ) * sizeof(char) );
	strcpy( tmpStr, "../" );

	for( i = 0; pname[i] != 0L; i++ )
		tmpStr[i+3] = tolower(pname[i]);

	tmpStr[i+3] = 0L;
	strcat( tmpStr, "-" );
	strcat( tmpStr, ver );
	strcat( tmpStr, ".lsm" );
	fp = fopen( tmpStr, "w" );
	free(tmpStr);

	fputs( "Begin3\n", fp );
	fputs( "Title:          ", fp );
	fputs( pname, fp );
	fputc( '\n', fp );
	fputs( "Version:        ", fp );
	fputs( ver, fp );
	fputc( '\n', fp );
	fputs( "Entered-date:   ", fp );
	fputs( udatet, fp );
	fputs( "Description:    A KDE program written with VisKProg\n", fp );
	fputs( "Keywords:       KDE Qt VisKProg\n", fp );
	fputs( "Author:         ", fp );
	fputs( author, fp );
	fputc( ' ', fp );
	fputs( mail, fp );
	fputc( '\n', fp );
	fputs( "Home-page:      ", fp );
	fputs( home, fp );
	fputc( '\n', fp );
	fputs( "Primary-site:   ftp://ftp.kde.org/pub/kde/", fp );

	if( prstability )
		fputs( "stable", fp );
	else
		fputs( "unstable", fp );

	fputs( "/apps/", fp );

	switch( prgroup )
	{
		case 1: /* Application */
			fputs( "utilities", fp );
			break;

		case 2: /* Utility */
			fputs( "utilities", fp );
			break;

		case 3: /* Game */
			fputs( "games", fp );
			break;
	}

	fputs( "\n                ", fp );
	fputs( pname, fp );
	fputc( '-', fp );
	fputs( ver, fp );
	fputs( ".tar.gz\n", fp );
	fputs( "                ", fp );
	fputs( pname, fp );
	fputc( '-', fp );
	fputs( ver, fp );
	fputs( ".lsm\n", fp );
	fputs( "Platform:       Linux. Needs Qt and KDE\n", fp );
	fputs( "Copying-policy: GPL\n", fp );
	fputs( "End\n", fp );

	fclose(fp);

	/* configure.in: */

	fp = fopen( "../configure.in", "r" );

	sptr = 0;
	fc = malloc( sizeof(char) );
	fc[0] = 0L;

	while( (c = fgetc(fp)) != EOF )
	{

		fc = realloc( fc, (strlen(fc)+2)*sizeof(char) );
		fc[strlen(fc)+1] = 0L;
		fc[strlen(fc)] = c;
	}

	fclose(fp);

	fp = fopen( "../configure.in", "w" );

	for( getR = nextWord(fc,0); strcmp("AM_INIT_AUTOMAKE", getR) != 0;
		getR =  nextWord(fc,0) )
			fputs( getR, fp );

	fputs( "AM_INIT_AUTOMAKE", fp );

	getR = nextWord(fc,1); /* '(' */
	fputc( '(', fp );

	getR = nextWord(fc,1); /* name */
	fputs( pname, fp );

	getR = nextWord(fc,1); /* ',' */
	fputs( ", ", fp );

	getR = nextWord(fc,1); /* version */
	fputs( ver, fp );

	getR = nextWord(fc,1); /* ')' */
	fputc( ')', fp );

	while( fc[sptr] != 0L )
	{
		fputc( fc[sptr], fp );
		sptr++;
	}

	free(fc);

	/* Changes in ../program/Makefile.am: */

	for( i = 0; pname[i] != 0L; i++ )
		pname[i] = tolower(pname[i]);

	fp = fopen( "../program/Makefile.am", "r" );

	sptr = 0;
	fc = malloc( sizeof(char) );
	fc[0] = 0L;

	while( (c = fgetc(fp)) != EOF )
	{

		fc = realloc( fc, (strlen(fc)+2)*sizeof(char) );
		fc[strlen(fc)+1] = 0L;
		fc[strlen(fc)] = c;
	}

	fclose(fp);

	fp = fopen( "../program/Makefile.am", "w" );

	for( getR = nextWord(fc,0); strcmp("APPSDIR", getR) != 0;
		getR =  nextWord(fc,0) )
			fputs( getR, fp );

	fputs( "APPSDIR = $(kde_appsdir)/", fp );

	switch( prgroup )
	{
		case 1:
			fputs( "Applications", fp );
			break;

		case 2:
			fputs( "Utilities", fp );
			break;

		case 3:
			fputs( "Games", fp );
			break;
	}

	getR = nextWord(fc,1); /* '=' */
	getR = nextWord(fc,1); /* '$' */
	getR = nextWord(fc,1); /* '(' */
	getR = nextWord(fc,1); /* "kde_appsdir" */
	getR = nextWord(fc,1); /* ')' */
	getR = nextWord(fc,1); /* '/' */
	getR = nextWord(fc,1); /* old group */


	for( getR = nextWord(fc,0); strcmp("bin_PROGRAMS", getR) != 0;
		getR =  nextWord(fc,0) )
			fputs( getR, fp );

	fputs( "bin_PROGRAMS = ", fp );

	getR = nextWord(fc,1); /* '=' */

	tmpStr = nextWord(fc,1); /* old binary name */
	fputs( pname, fp );

	while( (getR=nextWord(fc,0)) != 0L )
	{
		if( strncmp( getR, tmpStr, strlen(tmpStr) ) == 0
			&& getR[strlen(tmpStr)+1] != 'c' && getR[strlen(tmpStr)+1] != 'h'
			&& getR[strlen(tmpStr)+1] != 'm' )
		{ //Replace old name with the new one (if not a *.c(pp), *.h or *.m(oc) file)

			fputs( pname, fp );
			fputs( getR +strlen(tmpStr)*sizeof(char), fp );
		}
		else
			fputs( getR, fp );
	}

	free(fc);


	/* pics Makefile.am: */

	fp = fopen( "../program/pics/Makefile.am", "r" );

	sptr = 0;
	fc = malloc( sizeof(char) );
	fc[0] = 0L;

	while( (c = fgetc(fp)) != EOF )
	{

		fc = realloc( fc, (strlen(fc)+2)*sizeof(char) );
		fc[strlen(fc)+1] = 0L;
		fc[strlen(fc)] = c;
	}

	fclose(fp);

	fp = fopen( "../program/pics/Makefile.am", "w" );

	for( getR = nextWord(fc,0); strcmp("datadir", getR) != 0;
		getR =  nextWord(fc,0) )
			fputs( getR, fp );

	fputs( "datadir = $(kde_datadir)/", fp );
	fputs( pname, fp );

	getR = nextWord(fc,1); /* = */
	getR = nextWord(fc,1); /* $ */
	getR = nextWord(fc,1); /* ( */
	getR = nextWord(fc,1); /* kde_datadir */
	getR = nextWord(fc,1); /* ) */
	getR = nextWord(fc,1); /* / */
	getR = nextWord(fc,1); /* old project name */

	while( (getR=nextWord(fc,0)) != 0L )
			fputs( getR, fp );

	free(fc);

	/* Copy icons: */

	if( (fp = fopen("icon.xpm","r")) == 0L )
	{
		printf( "Can't open file ./icon.xpm\n" );
		exit(2);
	}

	tmpStr = malloc( ( strlen(pname) +strlen(ver) +16 ) * sizeof(char) );

	strcpy( tmpStr, "../program/" );
	strcat( tmpStr, pname );
	strcat( tmpStr, ".xpm" );

	fpd = fopen( tmpStr, "w" );
	free(tmpStr);

	while( (c=fgetc(fp)) != EOF )
		fputc( c, fpd );

	fclose(fp);
	fclose(fpd);


	if( (fp = fopen("mini-icon.xpm","r")) == 0L )
	{
		printf( "Can't open file ./mini-icon.xpm\n" );
		exit(2);
	}

	tmpStr = malloc( ( strlen(pname) +strlen(ver) +21 ) * sizeof(char) );

	strcpy( tmpStr, "../program/mini-" );
	strcat( tmpStr, pname );
	strcat( tmpStr, ".xpm" );

	fpd = fopen( tmpStr, "w" );
	free(tmpStr);

	while( (c=fgetc(fp)) != EOF )
		fputc( c, fpd );

	fclose(fp);
	fclose(fpd);

	/* Create kdelnk: */

	tmpStr = malloc( ( strlen(pname) +strlen(ver) +19 ) * sizeof(char) );

	strcpy( tmpStr, "../program/" );
	strcat( tmpStr, pname );
	strcat( tmpStr, ".kdelnk" );

	fp = fopen( tmpStr, "w" );
	free(tmpStr);

	fputs( "# KDE Config File ", fp );
	fputs(  pname, fp );
	fputc( '\n', fp );

	fputs( "[KDE Desktop Entry]\n", fp );

	fputs( "Name[C]=", fp );
	fputs(  pname, fp );
	fputc( '\n', fp );

	fputs( "Comment[C]=", fp );
	fputs(  "A VisKProg program", fp );
	fputc( '\n', fp );

	fputs( "Exec=", fp );
	fputs(  pname, fp );
	fputc( '\n', fp );

	fputs( "Icon=", fp );
	fputs(  pname, fp );
	fputs(  ".xpm", fp );
	fputc( '\n', fp );

	fputs( "Type=Application\n", fp );
	fputs( "Terminal=0\n", fp );

	fclose(fp);


} /* updateBase(...) */


void installcpp( char *fn )
{
FILE *fp, *fpd;
char *fc, *getR = " ";
char *tg, *tgc, *tgh, *tgm, *tmpStr;
char c;
int i;
int mocEntry = 0;

	printf( "vkProjectComposer: Installing %s in the KDE project ...\n", fn );

	for( i = strlen(fn)-1; fn[i] != '/'; i-- )
		if( i == 0 )
		{
			i--;
			break;
		}

	i++;

	tg = fn + i*sizeof(char);

	tgc = malloc( (strlen(tg)+1) *sizeof(char) );
	strcpy( tgc, tg );

	tgh = malloc( (strlen(tg)+1) *sizeof(char) );
	strcpy( tgh, tg );
	tgh[strlen(tgh)-3] = 'h';
	tgh[strlen(tgh)-2] = 0L;

	tgm = malloc( (strlen(tg)+1) *sizeof(char) );
	strcpy( tgm, tg );
	strcpy( tgm + (strlen(tg)-3)*sizeof(char), "moc" );


	/* First, copy the files: */
	if( (fp = fopen(fn,"r")) == 0L )
	{
		printf( "Can't open file %s\n", fn ); /* cpp */
		exit(2);
	}

	tmpStr = malloc( ( strlen(tg) +12 ) * sizeof(char) );

	strcpy( tmpStr, "../program/" );
	strcat( tmpStr, tgc );

	fpd = fopen( tmpStr, "w" );
	free(tmpStr);

	while( (c=fgetc(fp)) != EOF )
		fputc( c, fpd );

	fclose(fp);
	fclose(fpd);

	fn[strlen(fn)-3] = 'h';
	fn[strlen(fn)-2] = 0L;

	if( (fp = fopen(fn,"r")) == 0L )
	{
		printf( "Can't open file %s\n", fn ); /* h */
		exit(2);
	}

	tmpStr = malloc( ( strlen(tg) +12 ) * sizeof(char) );

	strcpy( tmpStr, "../program/" );
	strcat( tmpStr, tgh );

	fpd = fopen( tmpStr, "w" );
	free(tmpStr);

	while( (c=fgetc(fp)) != EOF )
		fputc( c, fpd );

	fclose(fp);
	fclose(fpd);

	/* Now, update the Makefile.am: */
	fp = fopen( "../program/Makefile.am", "r" );

	sptr = 0;
	fc = malloc( sizeof(char) );
	fc[0] = 0L;

	while( (c = fgetc(fp)) != EOF )
	{

		fc = realloc( fc, (strlen(fc)+2)*sizeof(char) );
		fc[strlen(fc)+1] = 0L;
		fc[strlen(fc)] = c;
	}

	fclose(fp);

	fp = fopen( "../program/Makefile.am", "w" );

	for( getR = nextWord(fc,0);
		strcmp( "_SOURCES", getR +(strlen(getR)-8)*sizeof(char) ) != 0;
		getR =  nextWord(fc,0) )
		{
			fputs( getR, fp );
		}

	fputs( getR, fp );
	fputs( " =", fp );

	getR = nextWord(fc,1); /* '=' */

	while( strcmp( (getR = nextWord(fc,0)), "\n" ) != 0 )
	{
		fputs( getR, fp );

		if( strcmp( getR, tgc ) == 0 )
			goto cpp_done; //Entry allready avaible
	}

	//Add entry:
	fputc( ' ', fp );
	fputs( tgc, fp );
	fputc( '\n', fp );

cpp_done:

	for( getR = nextWord(fc,0);
		strcmp( "_HEADERS", getR +(strlen(getR)-8)*sizeof(char) ) != 0;
		getR =  nextWord(fc,0) )
		{
			fputs( getR, fp );
		}

	fputs( getR, fp );
	fputs( " =", fp );

	getR = nextWord(fc,1); /* '=' */

	while( strcmp( (getR = nextWord(fc,0)), "\n" ) != 0 )
	{
		fputs( getR, fp );

		if( strcmp( getR, tgh ) == 0 )
			goto h_done; //Entry allready avaible
	}

	//Add entry:
	fputc( ' ', fp );
	fputs( tgh, fp );
	fputc( '\n', fp );

h_done:

	for( getR = nextWord(fc,0); strcmp( "BUILTSOURCES", getR ) != 0;
		getR =  nextWord(fc,0) )
			fputs( getR, fp );

	fputs( "BUILTSOURCES =", fp );

	getR = nextWord(fc,1); /* '=' */

	while( strcmp( (getR = nextWord(fc,0)), "\n" ) != 0 )
	{
		fputs( getR, fp );

		if( strcmp( getR, tgm ) == 0 )
			goto moc_done; //Entry allready avaible
	}

	//Add entry:
	fputc( ' ', fp );
	fputs( tgm, fp );
	fputc( '\n', fp );

moc_done:

	tmpStr = getR;

	while( (getR=nextWord(fc,0)) != 0L )
	{

		fputs( getR, fp );

		if( strcmp(tmpStr,tgm) == 0 && strcmp(getR,":") == 0 )
			mocEntry = 1;

		tmpStr = getR;
	}

	if( !mocEntry )
	{
		/*Add entry:*/
		fputs( "\n\n", fp );
		fputs( tgc, fp );
		fputs( ": ", fp );
		fputs( tgm, fp );
		fputc( '\n', fp );
		fputs( tgm, fp );
		fputs( ": ", fp );
		fputs( tgh, fp );
		fputs( "\n\t$(MOC) ", fp );
		fputs( tgh, fp );
		fputs( " -o ", fp );
		fputs( tgm, fp );
		fputc( '\n', fp );
	}

	free(fc);

	fclose(fp);

} /* installcpp(...) */


void installpic( char *fn )
{
FILE *fp, *fpd;
char *fc, *getR = " ";
char *tg, *tmpStr;
char c;
int i;

	printf( "vkProjectComposer: Installing %s in the KDE project ...\n", fn );

	for( i = strlen(fn)-1; fn[i] != '/'; i-- )
		if( i == 0 )
		{
			i--;
			break;
		}

	i++;

	tg = fn + i*sizeof(char);

	/* 1st copy the file: */
	if( (fp = fopen(fn,"r")) == 0L )
	{
		printf( "Can't open file %s\n", fn );
		exit(2);
	}

	tmpStr = malloc( ( strlen(tg) +17 ) * sizeof(char) );

	strcpy( tmpStr, "../program/pics/" );
	strcat( tmpStr, tg );

	fpd = fopen( tmpStr, "w" );
	free(tmpStr);

	while( (c=fgetc(fp)) != EOF )
		fputc( c, fpd );

	fclose(fp);
	fclose(fpd);

	/* Now, update the Makefile.am: */
	fp = fopen( "../program/pics/Makefile.am", "r" );

	sptr = 0;
	fc = malloc( sizeof(char) );
	fc[0] = 0L;

	while( (c = fgetc(fp)) != EOF )
	{

		fc = realloc( fc, (strlen(fc)+2)*sizeof(char) );
		fc[strlen(fc)+1] = 0L;
		fc[strlen(fc)] = c;
	}

	fclose(fp);

	fp = fopen( "../program/pics/Makefile.am", "w" );

	for( getR = nextWord(fc,0); strcmp("data_DATA", getR) != 0;
		getR =  nextWord(fc,0) )
			fputs( getR, fp );

	fputs( "data_DATA =", fp );

	getR = nextWord(fc,1); /* '=' */

	while( strcmp( (getR = nextWord(fc,0)), "\n" ) != 0 )
	{
		fputs( getR, fp );

		if( strcmp( getR, tg ) == 0 )
			goto datadata_done; //Entry allready avaible
	}

	//Add entry:
	fputc( ' ', fp );
	fputs( tg, fp );
	fputc( '\n', fp );

datadata_done:

	while( (getR=nextWord(fc,0)) != 0L )
			fputs( getR, fp );

	free(fc);
}


int isDir()
{
	return 1; /* Should check whether actual directory is "source" */
}

int cmpLow( char *w1, char *w2 )
{
int i;

	for( i = 1; w1[i] != 0L; i++ )
	{
		if( w2[i] == 0L ) return 1;

		if( tolower( w1[i] ) != tolower( w2[i] ) ) return -1;
	}

	if( w2[i] != 0L )
		return 2;
	else
		return 0;
}

void printUsage()
{
	printf( "\nUsage:\tvkProjectCreator command file\n\n" );
	printf( "List of accepted commands:\n" );
	printf( "\tbase \tUpdates the information in the KDE project. Needs project.conf\n" );
	printf( "\t     \tfile as argument. You must work in the ./source directory!\n" );
	printf( "\tdata \tCopies the given data from the VK project to the KDE project.\n" );
	printf( "\t     \tAt the moment, these files can be *.cpp files or *.xpm files.\n" );
	printf( "\t     \tIf it's a cpp file, vkProjectCreator expects the *.h file\n" );
	printf( "\t     \tof to be in the same directory as the *.cpp.\n" );
	printf( "\t     \tThis job updates the Makefile.am in the destination directory.\n" );
	printf( "\tclean\tRemoves all data from the KDE project.\n" );
}

int XFile( char *x, char *check )
{
int i = strlen(check)-1, ii = strlen(x) -1;

	while( ii > 0 )
	{
		if( check[i] != x[ii] )
			return 0;

		i--;
		ii--;

		if( i == 0 )
			return 0;
	}

	if ( check[i-1] == '.' )
		return 1;
	else
		return 0;


}


main( int argc, char **argv )
{
	if( argc < 2 )
	{
		printf( "vkProjectCreator: Missing command.\n" );
		printUsage();
		exit(1);
	}

	if( argc < 3 )
	{
		printf( "vkProjectCreator: Missing argument (file).\n" );
		printUsage();
		exit(1);
	}

	if( !isDir() )
	{
		printf( "Wrong work directory or invalid project structure: Start\n" );
		printf( "this program only in the ./source directory of your project.\n" );
		printUsage();
		exit(1);
	}

	/* Check argument (*.cpp, *.xpm ) */

	if( cmpLow( argv[1], "base" ) == 0 )
	{
		if( !XFile( "conf", argv[2] ) )
		{
			printf( "Second argument is not the project.conf file.\n" );
			printUsage();
			exit(1);
		}

		updateBase( argv[2] );
	}
	else if( cmpLow( argv[1], "data" ) == 0 )
	{
		if( !XFile( "cpp", argv[2] ) && !XFile( "h", argv[2] )
			&& !XFile( "xpm", argv[2] ) )
		{
			printf( "Second argument is not a data file (*.cpp *.xpm).\n" );
			printUsage();
			exit(1);
		}

		if( XFile( "cpp", argv[2] ) )
			installcpp( argv[2] );

		if( XFile( "xpm", argv[2] ) )
			installpic( argv[2] );
	}
	else
	{
		printf( "vkProjectCreator: Unknown command.\n" );
		printUsage();
		exit(1);
	}

}
