/*************************************************************
*
* (c) 1999, 2000 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#ifndef FTOP_H
#define FTOP_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <ktopwidget.h>
#include <kmenubar.h>
#include <qpopupmenu.h>
#include <ktoolbar.h>
#include <kstatusbar.h>
#include <kiconloader.h>
#include <kmsgbox.h>
#include <kfiledialog.h>
#include <qdir.h>
#include <kaccel.h>
#include <kprocess.h>

#include "winedit.h"
#include "wholder.h"
#include "vfdialog.h"
#include "startwin.h"
#include "Dec.h"

/******************************************************************************
	class KTopLevelWidget:
This class is only used in the stand alone version of KWinEdit, and so
it is useless in the IDE. It's the main window of the application and
(like in every standard KDE application) responsible for menus etc.
******************************************************************************/

class formedit : public KTopLevelWidget
{
	Q_OBJECT

public:
	/*Constructor; fn is a filename to open at start time or 0L */
	formedit( const char *fn = 0L );

public slots:
	//All slots for menu/toolbar connection
	void NewS();
	void OpenS();
	void SaveS();
	void QuitS();

	void cmd(int);
	void resetMenu(); //To be connected with childs: Activates pointer tool

	void runSrcEdit(QString,QString);

private:
	void createMenuBar();
	void createToolBar();
	void createStatusBar();

	//Uncheck the tool menu entries and untoggle the tool buttons.
	void uncheckTM();

	/* Returns the value of the 'Name' property of the given
	   widgetHolder this is needed to find the names for the
	   Edit/variables Edit/constants and Edit/Functions dialog: */
	QString getWHName( widgetHolder * );

	//Invoke the "Edit regional variables/constants" dialog:
	void editVars();

	//Invoke the "Edit regional constants" dialog:
	void editConst();

	//Invoke the "Edit regional functions" dialog:
	void editFuncs();

	void openNew();
	void open();
	void saveTo();
	void save();

	winedit *widget;

	KMenuBar *mainMenu;
	QPopupMenu *fileMenu;
	QPopupMenu *editMenu;
	QPopupMenu *toolMenu;
	QPopupMenu *helpMenu;
	KAccel *accel;
	KToolBar *mainToolBar;
	KToolBar *secondToolBar;
	KStatusBar *statusBar;

	vfDialog *fvd;
	bool dialogOK;

private slots:
	void tabDialogCancel();

};

#endif
