/*************************************************************
*
* (c) 1999, 2000 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#ifndef PEDI_H
#define PEDI_H

#include <qwidget.h>
#include <qdialog.h>
#include <qstring.h>
#include <qevent.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qpalette.h>
#include <qcolor.h>
#include <kmsgbox.h>
#include <kcolordlg.h>
#include <ctype.h>
#include <qscrollbar.h>

#include "ewidgets.h"
#include "pedidialogs.h"

#define PROP_FIELD_HEIGHT 20
#define DIALOG_WIDTH 250


/*******************************************************************************
*	class propField:
*       Widget to edit ONE property (one line of the property editor widget);
*       It invokes the set-value dialog or simply a eQLineEdit (see above).
*******************************************************************************/

class propField : public QWidget
{
	Q_OBJECT

public:
	propField( QString, QString, QWidget * );

	/* Is the property single or multi lined? (Only for properties
	   with text values): */
	inline void setML(bool nv) { allowMLCaption = nv; }

	void rejectChange();

signals:
	void changed( QString, QString, propField* );

private:
	void activate( bool );
	void cancelEdit();

	bool acceptChange( QString );

	virtual void resizeEvent( QResizeEvent * );

	virtual void focusInEvent( QFocusEvent * );
	virtual void focusOutEvent( QFocusEvent * );

	QString prop, val;
	QString oldVal;

	QLabel *pName;

	eQLabel *vText;
	eQLineEdit *vEdit;
	eQPushButton *vChange;

	QPalette myStdPal;
	QPalette lStdPal;

	bool allowMLCaption;
	mlDialog *mld;
	tfDialog *tfd;
	picDialog *pdlg;

	bool editMode;

private slots:
	void deActivate();
	void Activate();
	void edit();

};


/*******************************************************************************
*	class propEditWidget:
*       Manages the propFields; For each property a propField;
*	Emits the changed(...) signal to its parent.
*******************************************************************************/

class propEditWidget : public QWidget
{
	Q_OBJECT

public:
	propEditWidget( QString [], QString [], bool, QWidget * );

	inline void setCheckResult(bool b) { cR = b; }

signals:
	void changed( QString, QString );
	void checkName( QString );

private:
	virtual void resizeEvent( QResizeEvent * );

	bool changeAccepted( QString, QString );

	QString edit[2][100];

	propField *pf[100];

	bool cR;

private slots:
	void prChanged( QString, QString, propField * );

};


/*******************************************************************************
*	class propEditDialog:
*	A modal dialog window within a propEditWidget
*******************************************************************************/

class propEditDialog : public QDialog
{
	Q_OBJECT

public:
	propEditDialog( QString [], QString [], bool mlc=false );

signals:
	void changed( QString, QString );
	void checkName( QString );

public slots:
	void nameOk(bool);

private:
	virtual void resizeEvent( QResizeEvent * );

	propEditWidget *wid;
	QPushButton *bt;

	bool haveScrollBar;
	QScrollBar *scroll;

private slots:
	void close();
	void scrolled( int );

};

#endif