/*************************************************************
*
* (c) 1999, 2000 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#include "pedidialogs.h"
#include "pedidialogs.moc"

/***********************************************************************************
	class mlDialog:
************************************************************************************/

mlDialog::mlDialog( QString ltxt, QString defTxt ) : QDialog( 0L, "", true )
{
	txt = prfilter::mLines(defTxt);

	label = new QLabel( this );
	label->setText( ltxt );

	ed = new QMultiLineEdit( this );
	ed->setText( txt );
	ed->setFocus();

	ok = new QPushButton( "OK", this );
	ok->setDefault(true);

	cancel = new QPushButton( "Cancel", this );

	connect( ok, SIGNAL( clicked() ), SLOT( acceptDialog() ) );
	connect( cancel, SIGNAL( clicked() ), SLOT( rejectDialog() ) );

	setMinimumSize( 250, 200 );

	setCaption( "Change property" );

}


void mlDialog::resizeEvent( QResizeEvent * )
{
	label->setGeometry( 10, 10, width() -20, (height()-70)/2 );

	ed->setGeometry( 10, 20 +(height()-70)/2, width() -20, (height()-70)/2 );

	ok->setGeometry( width()/3 -35, height() -40, 70, 30 );

	cancel->setGeometry( 2*(width()/3) -35, height()-40, 70, 30 );
}


void mlDialog::acceptDialog() //SLOT
{
	txt = prfilter::oneLine(ed->text());
	accept();
}


void mlDialog::rejectDialog() //SLOT
{
	reject();
}

/***********************************************************************************
	class tfDialog:
************************************************************************************/

tfDialog::tfDialog( QString ltxt, bool b ) : QDialog( 0L, "", true )
{
	val = b;

	label = new QLabel( ltxt, this );

	grp = new QButtonGroup(this);
	grp->setExclusive(true);

	r1 = new QRadioButton( "TRUE", grp );
	r2 = new QRadioButton( "FALSE", grp );

	if (b)
		grp->setButton(0);
	else
		grp->setButton(1);

	ok = new QPushButton( "OK", this );
	ok->setDefault(true);

	cancel = new QPushButton( "Cancel", this );

	setCaption( "Change TRUE <-> FALSE" );

	setMinimumSize( 250, 200 );

	connect( grp, SIGNAL( clicked(int) ), SLOT( changed(int) ) );
	connect( ok, SIGNAL( clicked() ), SLOT( accept() ) );
	connect( cancel, SIGNAL( clicked() ), SLOT( reject() ) );
}


void tfDialog::resizeEvent( QResizeEvent * )
{
	label->setGeometry( 10, 10, width() -20, (height()-70)/2 );

	grp->setGeometry( 10, 20 +(height()-70)/2, width() -20, (height()-70)/2 );

	r1->setGeometry( 10, 10, grp->width() -20, (grp->height()-30)/2 );
	r2->setGeometry( 10, (grp->height()-30)/2 +20,
		grp->width() -20, (grp->height()-30)/2 );

	ok->setGeometry( width()/3-35, height()-40, 70, 30 );

	cancel->setGeometry( 2*width()/3-35, height()-40, 70, 30 );
}


void tfDialog::changed(int nv) //SLOT
{
	if( nv == 0 )
		val = true;
	else
		val = false;
}


/***********************************************************************************
	class picDialog:
************************************************************************************/

picDialog::picDialog( QString old ) : QDialog( 0L, "", true )
{
QDir picDir( "../pics" );
QStrList *pics;

	pics = picDir.entryList( "*.xpm" );

	val = old;

	label = new QLabel( "Please select a picture from\nthe list.", this );

	list = new QListBox( this );
	list->insertItem( "(none)" );
	list->insertStrList(pics);

	ok = new QPushButton( "Close", this );
	ok->setDefault(true);

	add = new QPushButton( "Add file", this );

	setCaption( "Select pixmap" );

	setMinimumSize( 250, 300 );

	connect( ok, SIGNAL( clicked() ), SLOT( accept() ) );
	connect( add, SIGNAL( clicked() ), SLOT( addPic() ) );
	connect( list, SIGNAL( highlighted(const char*) ), SLOT( change(const char*) ) );

}


void picDialog::resizeEvent( QResizeEvent * )
{
	label->setGeometry( 10, 10, width() -20, 40 );

	list->setGeometry( 10, 50, width() -20, height()-100 );

	ok->setGeometry( 2*width()/3-40, height()-40, 80, 30 );
	add->setGeometry( width()/3-40, height()-40, 80, 30 );
}

void picDialog::change( const char *newVal )
{
	val = newVal;
}

void picDialog::addPic()
{
QFile f, f2;
int i;
int ch;

	QString fn = KFileDialog::getOpenFileName();

	if ( fn.isNull() )
		return;

	f.setName(fn);

	if (!f.open(IO_ReadOnly))
	{
		KMsgBox::message( 0L, "Error", "Can't open file." );
		return;
	}

	for( i = fn.length(); fn[i] != '/'; i-- );

	f2.setName(QString( "../pics" + fn.right( fn.length()-i ) ));

	if (!f2.open(IO_WriteOnly))
	{
		KMsgBox::message( 0L, "Error", "Can't open destination file." );
		f.close();
		return;
	}

	for( ch = f.getch(); ch != -1; ch = f.getch() )
		f2.putch(ch);

	f.close();
	f2.close();

	list->insertItem( fn.right( fn.length()-i-1 ) );
}