/***************************************************************************
                          tagtablehead.cpp  -  description
                             -------------------
    begin                : Sun Nov 28 1999
    copyright            : (C) 1999 by Yacovlev Alexander & Dmitry Poplavsky
    email                : pdima@mail.univ.kiev.ua
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "tagtablehead.h"
#include <stdio.h>

TagTableHead::TagTableHead(QWidget *parent, const char *name) : QDialog(parent,name,true){
	setCaption(name);
	initDialog();
	
	static const char *talign[] = { "", "left", "right", "center",0};
	static const char *tvalign[] = { "", "top", "bottom", "middle",0};
	comboAlign->insertStrList( talign);
	comboVAlign->insertStrList( tvalign);
	
	connect( buttonOk, SIGNAL(clicked()), SLOT(accept()) );
	connect( buttonCancel, SIGNAL(clicked()), SLOT(reject()) );
	connect( colorButton, SIGNAL(changed(const QColor &)), this, SLOT(slotColor(const QColor &)) );
}

TagTableHead::~TagTableHead(){
}

/** for color select */
void TagTableHead::slotColor(const QColor &newColor){
	char c[8];
	
	sprintf((char *)c,"#%2X%2X%2X",newColor.red(),newColor.green(),newColor.blue());
	for (int i=0;i<7;i++) if (c[i] == ' ') c[i] = '0';
	
	comboBGColor->setEditText((char *)c);
}