/*
 * TopLevelWidget implementation.
 *
 * $Id: ktlw.cpp,v 1.4 1998/08/05 16:36:03 core Exp $
 *
 */


#include <qpushbt.h>
#include <qlayout.h>
#include <qtabbar.h>
#include <qlabel.h>
#include <qsize.h>
#include <qgrpbox.h>
#include <qmsgbox.h>

#include <kdebug.h>
#include <kpanner.h>
#include <ktablistbox.h>
#include <kprogress.h>
#include <qtabdlg.h>

#include <qmsgbox.h>
#include <sys/vfs.h>

#include "ktlw.h"
#include "ktlw.moc"

#include "kprop.h"

#define bufferConfigFile "buffer.stat"


KTlw::KTlw( const char *name = 0L )
  : KTopLevelWidget( name )
{
  QString tmp;
  
  config = kapp->getConfig();
  config->setGroup( "General" );
  
  tmp = config->readEntry( "BufferPath", "/tmp/" );
  if ( tmp.right( 1 ) != "/" ) config->writeEntry( "BufferPath", tmp+"/" );
  
  buffConfig = new KSimpleConfig( config->readEntry( "BufferPath", "/tmp/" )+bufferConfigFile );
  // buffConfig = new KSimpleConfig( "/tmp/buffer.stat" );

  setupUI();
  setupMenuBar();    // includes Status Bar
  loadBuffer();

  resize( 700, 500 );  // i know - ther's something called SessionManagment..  [ ToDo ]

  // show startup info dialog ?
  showStartupInfo();
}

KTlw::~KTlw()
{
  saveBuffer();
  delete buffConfig;
}

void KTlw::setupUI()
{
  KPanner *panner = new KPanner( this, "panner");   
  panner->setSeparator( 40);
  
  QBoxLayout *layout0 = new QVBoxLayout( panner->child0(), 4, 0);
  
  QTabBar *tabBar0 = new QTabBar( panner-> child0() );
  QTab *tab = new QTab;
  tab->label=klocale->translate("Buffer");
  tab->enabled = TRUE;
  tabBar0->addTab(tab);
  QSize size = tabBar0->sizeHint();
  tabBar0->setFixedHeight( size.height() );
  layout0->addWidget( tabBar0 );
  
  QGroupBox *group = new QGroupBox( panner->child0() );
  layout0->addWidget( group );
  
  QBoxLayout *layout1 = new QVBoxLayout( group, 8, 3 );
  bufList = new KTrackListBox( group, "buffer", 4);
  bufList->setColumn( 0, klocale->translate("Title"), 120);
  bufList->setColumn( 1, klocale->translate("Time"), 50);
  bufList->setColumn( 2, klocale->translate("Size"), 35);
  bufList->setColumn( 3, klocale->translate("Filename"), 200);
  bufList->setSeparator('\t');
  bufList->allowDrag( true );
  bufList->setDragSource( 0 );
  layout1->addWidget( bufList );                             // okey - BufferList was added
  buffDropZone = new KDNDDropZone( bufList, DndRawData );       // add drop support
  connect( buffDropZone, SIGNAL( dropAction( KDNDDropZone * )), this, SLOT( buffDropAction( KDNDDropZone * )));

  layout1->addSpacing(4);
  diskUsageProgress = new KProgress( group );
  size = diskUsageProgress->sizeHint();
  diskUsageProgress->setFixedHeight( size.height() );
  layout1->addWidget( diskUsageProgress );

  // now setup the right side of our window
    
  layout1 = new QVBoxLayout( panner->child1(), 4, 0 );
  tabBar = new QTabBar ( panner->child1() );  // create TabBar and fill it
  tab = new QTab;
  tab->label = klocale->translate("&Write CD-R");
  tab->enabled = TRUE;
  tabBar->addTab(tab);
  tab = new QTab;
  tab->label = klocale->translate("Read &audio CD");
  tab->enabled = TRUE;
  tabBar->addTab(tab);

  /*
    This is all ToDo - Frenando was interested in doing "Master data CD" - correct ?

    tab = new QTab;
    tab->label = klocale->translate("&Read &data CD");
    tab->enabled = TRUE;
    tabBar->addTab(tab); */
    //Descomento esto ahora un ratito....
    tab = new QTab;
    tab->label = klocale->translate("&Master data CD");
    tab->enabled = TRUE;
    tabBar->addTab(tab); 
    
  size = tabBar0->sizeHint();                // TabBar uses fixed height
  tabBar->setFixedHeight( size.height() );
  layout1->addWidget( tabBar );

  /* the spacer-widget is to take all the remaining space on the left side
     of the panner.... the size of the currently visible "Module" is syncron
     to the spacer.
  */
  spacer = new QWidget( panner->child1(), "Spacer" );
  layout1->addWidget( spacer );

  writeCdr = new KWriteCdr( panner->child1(), bufList );
  writeCdr->hide();
  connect( writeCdr, SIGNAL( updateStatus( QString, int ) ), this, SLOT( updateStatus( QString, int ) ) );
  connect( this, SIGNAL( deleteTrack( CdTrackInfo * ) ), writeCdr, SLOT( buffDeleteTrack( CdTrackInfo * ) ) );
  readAudioCd = new KReadAudioCd( panner->child1(), bufList );
  readAudioCd->hide();
  connect( readAudioCd, SIGNAL( setFilenameInBuff( CdTrackInfo *, QString )), this, SLOT( setFilename( CdTrackInfo *, QString ))) ;
  connect( this, SIGNAL( deleteTrack( CdTrackInfo * ) ), readAudioCd, SLOT( buffDeleteTrack( CdTrackInfo * ) ));
  connect( readAudioCd, SIGNAL( setFilenameInBuff( CdTrackInfo *, QString )), writeCdr, SLOT( setFilename( CdTrackInfo *, QString )));
  connect( readAudioCd, SIGNAL( saveBuffer() ), this, SLOT( saveBuffer() ) );
  connect( readAudioCd, SIGNAL( updateStatus( QString, int ) ), this, SLOT( updateStatus( QString, int ) ) );
  connect( readAudioCd, SIGNAL( addTrackToBuff( CdTrackInfo *, QString, QString )), this, SLOT( addTrack( CdTrackInfo *, QString, QString ) ) );
  
  masterDataCd = new KMasterDataCd ( panner->child1()  );
  masterDataCd->hide();
 

  connect( tabBar, SIGNAL(selected( int )), this, SLOT(setMode( int )) );
  connect( panner, SIGNAL(positionChanged()), this, SLOT(resizeModes()) );
  
  setView( panner );
  startTimer( 1000 );
}

void KTlw::setupMenuBar()
{
  QPopupMenu *helpMenu = kapp->getHelpMenu( true, "kcdwrite was written by Joerg Bornschein" );

  QPopupMenu *fileMenu = new QPopupMenu();
  fileMenu->insertItem( klocale->translate( "&Open writelist..." ), this, SLOT( open() ) );
  fileMenu->insertItem( klocale->translate( "&Save writelist" ), this, SLOT( save() ) );
  fileMenu->insertItem( klocale->translate( "Save writelist &as..." ), this, SLOT( saveAs() ) );
  fileMenu->insertSeparator();
  fileMenu->insertItem( klocale->translate( "&Configure..." ), this, SLOT( configure() ) );
  fileMenu->insertSeparator();
  fileMenu->insertItem( klocale->translate( "&Quit") , this, SLOT( quit() ) );
  
  QPopupMenu *buffMenu = new QPopupMenu();
  buffMenu->insertItem( klocale->translate( "&Rename track" ), this, SLOT( renameTrack() ) );
  buffMenu->insertItem( klocale->translate( "&Delete track" ), this, SLOT( deleteTrack() ) );
  buffMenu->insertItem( klocale->translate( "Delete &all tracks" ), this, SLOT( deleteAllTracks() ) );

  QPopupMenu *modeMenu = new QPopupMenu();
  modeMenu->insertItem( klocale->translate( "&Write CD-R" ), 0 ); 
  modeMenu->insertItem( klocale->translate( "Read &audio CD" ), 1 );
  modeMenu->insertItem( klocale->translate( "Read &data CD" ), 2 );
  modeMenu->insertItem( klocale->translate( "&Master data CD" ), 3 );


  KMenuBar *menu = new KMenuBar( this, "Menu" );
  menu->insertItem( klocale->translate( "&File" ), fileMenu );
  menu->insertItem( klocale->translate( "&Buffer" ), buffMenu );
  menu->insertItem( klocale->translate( "F&unction" ), modeMenu );
  menu->insertSeparator();
  menu->insertItem( klocale->translate("&Help"), helpMenu); 
  
  setMenu( menu );

  // connects function-items to KTlw::setMode( int )
  connect(modeMenu, SIGNAL(activated(int)), this, SLOT(setMode(int)));


  // setup StatusBar
  statusBar = new KStatusBar( this );
  statusProgress = new KProgress( statusBar );
  statusProgress->setFixedWidth( 150 );
  statusBar->insertWidget( statusProgress, 150, 0 );
  statusBar->insertItem( "                              ", 1 );
  updateStatus(  klocale->translate( "Hint: use dragn drop and shift-click in list boxes" ), -1 );
  setStatusBar( statusBar );
}

void KTlw::resizeEvent( QResizeEvent *aResizeEvent )
{
  KTopLevelWidget::resizeEvent( aResizeEvent );
  resizeModes();
}

void KTlw::show()
{
  KTopLevelWidget::show();
  resizeModes();
}


void KTlw::resizeModes()
{
  QRect rect = rect = spacer->geometry();
  writeCdr->setGeometry( rect );
  readAudioCd->setGeometry( rect );
  masterDataCd->setGeometry( rect );
}


void KTlw::showStartupInfo()
{
  if ( config->readEntry("StartupInfoDlg", "1") != "0" ) {
    QMessageBox *msgDlg = new QMessageBox( this, "info" );
    msgDlg->setCaption( klocale->translate("kcdwrite information") );
    msgDlg->setText( klocale->translate( "!WARNING:\n This is a early beta version so there`s no reason to expect any bugs.\n" \
					 " But if you find any please report them to <core@disorder.ruhr.de>. The actual work\n" \
					 " [reading and writing cds] is done by other people programs\n\n" \
					 " Please remember to setup your tools by choosing <File>/<Configure>\n\n" ) );

    msgDlg->exec();
    delete msgDlg;
  };
}


void KTlw::configure()
{
  KcdrProp *dlg = new KcdrProp();
  dlg->exec();              // the dialog does everyting itself......
  delete dlg;

  delete buffConfig;
  buffConfig = new KSimpleConfig( config->readEntry( "BufferPath", "/tmp/" )+bufferConfigFile );
}

void KTlw::open()
{
}

void KTlw::save()
{
}

void KTlw::saveAs()
{
}

void KTlw::renameTrack()
{
}

void KTlw::deleteTrack()
{
  int i;
  KProcess proc;
  
  if ( QMessageBox::information( this, klocale->translate( "kcdwrinte: delete tracks" ),
				 klocale->translate( "Really delete all selected tracks ?" ),
				 klocale->translate( "&Yes" ), klocale->translate( "&No" ), 0,
				 0, 1 ) == 0 ) 
    {
      proc << "rm" << "-f";
      bufList->setAutoUpdate( false );
      for ( i=0; i < bufList->count(); i++ ) {
	if ( bufList->isMarked( i ) == true ) {
	  if ( !trackUsed( i ) ) {
	    emit deleteTrack( bufList->track( i ) );
	    if ( bufList->filename( i ).left( 1 ) == "/" ) proc << bufList->filename( i );
	    bufList->removeTrack( i );
	    i--;
	  };
	};
      };
      updateStatus( klocale->translate( "deleting tracks..." ), -1 );
      bufList->setAutoUpdate( true );
      bufList->repaint();
      proc.start( KProcess::DontCare );
      bufList->unmarkAll();
    };
}

void KTlw::deleteAllTracks() 
{  
  int i;
  KProcess proc;
  
  if ( QMessageBox::information( this, klocale->translate( "kcdwrinte: delete all tracks" ),
				 klocale->translate( "Really delete ALL tracks in buffer ?" ),
				 klocale->translate( "&Yes" ), klocale->translate( "&No" ), 0,
				 0, 1 ) == 0 )
    {
      proc << "rm" << "-f";
      bufList->setAutoUpdate( false );
      for ( i=0; i < bufList->count(); i++ ) {
	if ( !trackUsed( i ) ) {
	  proc << bufList->filename( i );
	  emit deleteTrack( bufList->track( i ) );
	  bufList->removeTrack( i );
	  i--;
	};
      };
      updateStatus( klocale->translate( "deleting tracks..."), -1 );
      bufList->setAutoUpdate( true );
      bufList->repaint();
      proc.start( KProcess::DontCare );
      bufList->unmarkAll();
    };
}

bool KTlw::trackUsed( int i )
{
  CdTrackInfo *track;
  QString tmp;

  track = bufList->track( i );
  if ( writeCdr->writeListBox->pos( track ) != -1 ) {
    tmp.sprintf( klocale->translate( "Track \"%s\" is queued in write list\n\nReally delete ?" ), bufList->title( i ).data() );
    if ( QMessageBox::information( this, "kcdwrite", tmp, 
				klocale->translate( "&Yes" ), klocale->translate( "&No" ), 0, 1, 1 ) == 1 ) 
      {
	return true;
      };
  };
  return false;
}


void KTlw::updateDiskUsage(int add)
{
  diskUsageProgress->setValue(add);
}

void KTlw::setMode(int mode)
{
  readAudioCd->hide();
  writeCdr->hide();
  masterDataCd->hide();
  switch( mode )
    {
    case 0:
      writeCdr->show();
      break;
    case 1:
      readAudioCd->show();
      break;
    case 2:
      masterDataCd->show();
      break;
    default:
      KDEBUG1( KDEBUG_INFO, 0, "Illegal mode %d choosen", mode); 
    }
}

void KTlw::buffDropAction( KDNDDropZone *zone )
{
  DragData *dd;
  int i, listCount;
  QString warning, tmp;
  bool displayWarning;

  displayWarning = false;

  dd = (DragData *)zone->getData();
  switch ( dd->dragSource )
    {
    case 1:                                // drag from readAudioCd
      warning = klocale->translate( "Please note following errors:\n" );
      bufList->setAutoUpdate( false );
      listCount = readAudioCd->cdListBox->count();
      for ( i=0; i<listCount; i++ ) {
	if ( readAudioCd->cdListBox->isMarked( i ) ) {
	  if ( bufList->pos( readAudioCd->cdListBox->track( i ) ) == -1 )  // check for dublicate entries
	       {     
		 addTrack( readAudioCd->cdListBox->track( i ),
			   readAudioCd->cdListBox->title( i ),
			   " " );
	       } else {  // already in buffer - add a warning.....
		 warning += tmp.sprintf( klocale->translate( "  %s already in buffer - not added\n" ), 
					 readAudioCd->cdListBox->title( i ).data() );
		 displayWarning = true;
	       };
	};
      };
      bufList->setAutoUpdate( true );
      bufList->unmarkAll();
      bufList->repaint();
      readAudioCd->cdListBox->unmarkAll();
      break;
    default:
      break;
    };
      
  if ( displayWarning ) {
    QMessageBox::warning( this, klocale->translate( "kcdwrite: warning" ),
			  warning, klocale->translate( "&OK" ) );			  
  };
}

void KTlw::addTrack( CdTrackInfo *track, QString title, QString filename )
{
  CdTrackInfo *newTrack;

  newTrack = new CdTrackInfo( track ); // clone track
  bufList->insertTrack( newTrack, title, filename );
  readAudioCd->queueTrack( track );
}

void KTlw::setFilename( CdTrackInfo *track, QString filename )
{
  bufList->setFilename( bufList->pos( track ), filename );
}

void KTlw::saveBuffer()
{
  int i, count;
  QString tmp;
  
  count = bufList->count();
  for ( i = 0; i < count; i++ ) {
    tmp.sprintf( "Track%d", i );
    buffConfig->setGroup( tmp );
    buffConfig->writeEntry( "Title", bufList->title( i ) );
    buffConfig->writeEntry( "Filename", bufList->filename( i ) );
    buffConfig->writeEntry( "Track", bufList->track( i )->track() );
    buffConfig->writeEntry( "Frames", bufList->track( i )->trackFrames() );
  };
  tmp.sprintf( "Track%d", count );
  buffConfig->deleteGroup( tmp, true );
  buffConfig->sync();
}

void KTlw::loadBuffer()
{
  int i,j;
  QString tmp, tmp2;
  CdTrackInfo *track;

  i = 0;
  tmp.sprintf( "Track%d", i );
  buffConfig->setGroup( tmp );
  j = buffConfig->readNumEntry( "Frames", -1 );
  while ( j != -1 ) {
    tmp = buffConfig->readEntry( "Title", "" );
    tmp2 = buffConfig->readEntry( "Filename", "" );
    if ( tmp2.left( 1 ) == "/" ) {
      track = new CdTrackInfo();
      track->setTrack( buffConfig->readNumEntry( "Track", 1 ) );
      track->setFrames( j );
      bufList->insertTrack( track, tmp, tmp2 );
    };
    i++;
    tmp.sprintf( "Track%d", i );
    buffConfig->setGroup( tmp );
    j = buffConfig->readNumEntry( "Frames", -1 );
  }
}

void KTlw::updateStatus( QString msg, int percent )
{
  
  statusBar->changeItem( msg, 1 );
  if ( percent == -1 ) {
    statusProgress->setTextEnabled( false );
    statusProgress->setValue( 0 );
  } else {
    statusProgress->setTextEnabled( true );
    statusProgress->setValue( percent );
  };
}

void KTlw::updateUsage()
{
  struct statfs stat_buf;
  QString tmp;
  long i;

  statfs( config->readEntry( "BufferPath", "/tmp/").data(), &stat_buf );
  i = stat_buf.f_blocks / 100;
  i = ( stat_buf.f_blocks - stat_buf.f_bavail ) / i;
  if ( true ) {
    if ( i > 85 ) { 
      diskUsageProgress->setBarColor( QColor( 0xAA, 0x00, 0x00 ) );
      tmp.sprintf( klocale->translate( "Warning: device %d\%% full -  %d MB avail !" ), i, stat_buf.f_bavail / 1000 );
      updateStatus( tmp, -1 );
    } else {
      diskUsageProgress->setBarColor( QColor( 0x00, 0x00, 0x99 ) );
    }
    diskUsageProgress->setValue( i );
  }
}

void KTlw::timerEvent( QTimerEvent *tevent )
{
  updateUsage();
}

void KTlw::closeEvent( QCloseEvent *e )
{
  if ( quitOk() ) {
    e->accept();
  } else {
    e->ignore();
  };
}

bool KTlw::quitOk()
{
  if ( writeCdr->quitOk() && readAudioCd->quitOk() ) {

    // ToDo: check for running "rm"

    return true;
  } else {
    return false;
  }
}

void KTlw::quit()
{
  if ( quitOk() ) kapp->quit();
}
