#ifndef _kwritecdr_h
#define _kwritecdr_h

/*
 *
 *
 *
 *
 *
 */

#include <qgrpbox.h>
#include <qpushbt.h>
#include <qlayout.h>
#include <qbttngrp.h>
#include <qchkbox.h>
#include <qradiobt.h>
#include <qlabel.h>

#include <kprogress.h>
#include <kconfig.h>
#include <kapp.h>
#include <kprocess.h>
#include <drag.h>

#include "ktracklst.h"

class KWriteCdr : public QGroupBox
{
  Q_OBJECT
  
 public:
  KWriteCdr( QWidget *parent = 0, KTrackListBox *aBufListBox = 0); 
  ~KWriteCdr();
  
  bool quitOk();

 public slots:
  void updateUsage();
  void setFilename( CdTrackInfo *track, QString filename );
  void setTitle( CdTrackInfo *track, QString title );
  void dropAction( KDNDDropZone *zone );
  void buffDeleteTrack( CdTrackInfo *track );
  void childExited( KProcess * );

  void pbtAddTracks();
  void pbtAddAllTracks();
  void pbtDelTracks();
  void pbtUpTrack();
  void pbtDownTrack();
  void pbtStartWriting();

 signals:
  void updateStatus( QString msg, int percent );
  
 public:
  KConfig *config;
  KDNDDropZone *dropZone;
  KTrackListBox *writeListBox, *bufListBox;
  QPushButton *startWriting;
  KProgress *cdrUsage;
  QLabel *cdrSize;
  QLabel *cdrTime;
  QRadioButton *CdrLength74, *CdrLength63;
  QCheckBox *dummyWrite;
  QCheckBox *ejectAfterWrite;
  KShellProcess *proc;
};


#endif
