/**************************************************************************
                          keasycdview.h  -  description                              
                             -------------------                                         
    begin                : Sun Feb  7 09:35:03 MET 1999
                                           
    copyright            : (C) 1999 by Marcel Borred                         
    email                : marcel.borreda@post.rwth-aachen.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef KEASYCDVIEW_H
#define KEASYCDVIEW_H
//Application metrics
#define APPHEIGHT 500
#define APPWIDTH  600
#define BORDER 70

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 
// qt
#include <qwidget.h>
#include <qpixmap.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qgroupbox.h>
#include <qdir.h>
#include <qstring.h>
#include <drag.h>
#include <qlineedit.h>
#include <qregexp.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qtooltip.h>

//kde
#include <kapp.h>
#include <ktabctl.h>
#include <kmsgbox.h>
#include <kbuttonbox.h>
#include <kwizard.h>
#include <kdirlistbox.h>
#include <kfiledetaillist.h>
#include <ktreelist.h>
#include <kprogress.h>
#include <kcombo.h>
#include <kbutton.h>
#include <kfiledialog.h>
#include <kprocess.h>
#include <kiconloader.h>
#include <kquickhelp.h>

//others
#include "echklist.h"





/**
  * This class provides an incomplete base for your application view. 
  * This also requires a new implementation of resizeEvent so your view is
  * displayed correctly.  Your View Widget should provide methods to handle
  * the users actions on the view and interact with the doc class of the
  * application to set the modified flag for the document. 
  * Example:  You decided to use a QMultilineEdit widget in your view. This
  * Widget emits a signal textChaged() if the user changes the text. Then, you
  * could use this signal to connect to the slot of the doc class to set the
  * modified flag (which then enables the save and save as items.   */ 

class KEasyCDView : public QWidget
{
  Q_OBJECT

 public:
  /** Constructor for the main view */
  KEasyCDView(QWidget *parent = 0, const char *name = 0);
  /** Destructor for the main view */
  virtual ~KEasyCDView();
 //Tab Pages
KTabCtl *tabctl;
QWidget *Page;

KShellProcess *sysinfo;


//Tree List
KTreeList *datatree, *audiotree;
KTreeListItem *dataitem, *audioitem;
//drag and drop
KDNDDropZone *dzonedata, *dzoneaudio;



//misc
KMsgBox *msgbox;

QPixmap *audiopixmap, *datapixmap, *folder,*maudiopixmap, *mdatapixmap, *clock, *sound;
QLabel *strvolumeid,*strpublisherid,*strpreparerid,*strappid, *strcdbname, *strcdrname;
QGroupBox *groupfsoptions, *groupeltorito, *groupdevice;
KCombo *fscombo, *cdbcombo, *cdrcombo, *cdrspeed, *cdbspeed;
KProgress *progressbar;
KFileDialog *filedialog;
KIconLoader *Icon;
QTimer *t;
//mkisofs
//Filesystem General
//RockRidge Extensions
QCheckBox *susprr; // -R generate SUSP and RR records to further describe files (RockRidge)
QCheckBox *susprr2; // -r set more usefull values than -R e.g. files on cd
QCheckBox *generatetbl; // -T generate TRANS.TBL files better readable on non RockRidge
QCheckBox *generatesuspforcompressed; // -z
//Joliet
QCheckBox *joliet; // -J activate joliet
//Filesystem special
QCheckBox *nodeepdirreloc; // -D
QCheckBox *followsymlinks; // -f not RockRidge
QCheckBox *sunos414cdbugcomponets; // -no-split-symlink-components
QCheckBox *sunos414cdbigfields; // -no-split-symlink-fields

//file conventions
QCheckBox *allfiles; // -a  include also ~ and # files
QCheckBox *trailingperiod; // -d omit from files with no period caution!!
QCheckBox *allow32cfilenames; // -l allows files with 32 characters ->problems with dos
QCheckBox *allowdot; // -L if not will be replaced with _ (for DOS)
QCheckBox *omitversionnumbers; // -N caution on ISO filesystem omits version number

//output
QCheckBox *printsize; // -print-size get filesystem size before piping to cdrecord
QCheckBox *verbose; // -v verbose

//CD Header
QLineEdit *volumeid; // -V volumeid in master block
QLineEdit *publisherid; // -P Auhtorname in Volumeheader mail address and phone number
QLineEdit *preparerid; // -p preparer of CD (128 chars) mail address and phone number
QLineEdit *appid;    // -A (max 128c) describes app on cd

//bootable cd
QLineEdit *eltorito; // -b  path and file  to boot image (size 1.2, 1.44 or 2.88)
QLineEdit *bootcatalog; // -c path and file of boot catalog (will be created)
KButton *keltorito;
KButton *kbootcatalog;
QLabel  *leltorito;
QLabel *lbootcatalog;

//multisession
QLineEdit *mergeimage; // -M path to other image to merge with (for multisession)


//excluding conventions
QLineEdit *excludeglob; // -m (in wildcard pattern which files to exclude)
QLineEdit *excludepath; // -x exclude path

 /*foo/bar/=../old.lis

       will  include  the  file  old.lis  in  the  cdrom image at
       /foo/bar/old.lis, while

            foo/bar/xxx=../old.lis
  at foo/bar/xxx
*/
//cdrecord
// cdrecord [ general options ] dev=device [  track  options  ]
//     track1...trackn
//dev=  devicename:scsibus,target
QGroupBox *recoptions;
QCheckBox *cdrecversion;// -version
//          Print version information and exit.
//
 KProgress *cdrecverbose;//     -v    Increment the level of general verbosity by one.  This
//          is  used  e.g.  to  display the progress of the writing
//          process.
 QCheckBox *cdrecverbosescsi;//
 QCheckBox *cdrecshowbuffer;//     -V    Increment the verbose level in respect of SCSI command
 QLabel *full;
 QLabel *empty;
 QLabel *bufferOK;
 QLabel *bufferdanger;
 KProgress *showbuffer;//          transport  by one.  This helps to debug problems during
 QGroupBox *buffergroup;//          the writing process, that occur in the CD-Recorder.  If
//          you  get incomprehensible error messages you should use
//          this flag to get more detailed output.  -VV  will  show
//          data buffer content in addition.  Using -V or -VV slows
//          down the process and may be the  reason  for  a  buffer
//          underrun.  Using
 QCheckBox *debug; // -debug (buffer underrun)
 QCheckBox *dummy; // -dummy dummy write
 QCheckBox *multi; // -multi create multisession cd and   -data for sony

//Pushbuttons
QCheckBox *msinfo; // -msinfo get multisession info
QCheckBox *toc;            // -toc print table of contents
QCheckBox *fixdisk; // -fix only fix disk

 QCheckBox *nofix; // -nofix do not fix disk
 QCheckBox *load; // -load (for Kodak disk transporter
 QCheckBox *eject; // -eject (eject, for philips)
//groupbox
QCheckBox *speed; // -speed= set writing speed (0,2 or 4)

//Spinbox Group
QLineEdit *tsize;      //  tsize=#         Length of valid data in next track
QLineEdit *padsize;      //  padsize=#       Amount of padding for next track
QLineEdit *pregap;      //  pregap=#        Amount of pre-gap sectors before next track
QLineEdit *defpregrap;      //  defpregap=#     Amount of pre-gap sectors for all but track #1

QCheckBox   *isosize;   //  -isosize        Use iso9660 file system size for next data track

 QCheckBox   *preemp;   //  -preemp         Audio tracks are mastered with 50/15 s preemphasis
   //QCheckBox   *nopreemp;   //  -nopreemp       Audio tracks are mastered with no preemphasis (default)
 QCheckBox   *pad;   //  -pad            Pad data tracks with 15 zeroed sectors
      //                 Pad audio tracks to a multiple of 2352 bytes
  //QCheckBox  *nopad;    //  -nopad          Do not pad data tracks (default)
 QCheckBox  *swap;    //  -swab           Audio data source is byte-swapped (little-endian/Intel)

QLineEdit *timeout;      // timeout=#       set the default SCSI command timeout to #. default 40 seconds
QLineEdit *driver;     //  driver=name     user supplied driver name, use with extreme care
QCheckBox *checkdrive;      //  -checkdrive     check if a driver for the drive is present
QCheckBox *printcap;      //  -prcap          print drive capabilities for MMC compliant drives
QCheckBox *inquiry;      //  -inq            do an inquiry for the drive end exit
QCheckBox *scanbus;      //  -scanbus        scan the SCSI bus end exit
QCheckBox *reset;      //  -reset          reset the SCSI bus with the cdrecorder (if possible)
 QCheckBox *ignsize;      //  -ignsize        ignore the known size of a medium (may cause problems)
QLineEdit *fifosize;      //  fs=#            Set fifo size to # (0 to disable, default is 4 MB)
//checkbox for on the fly writing
//lineedit for image path

//Packet Writing;
 QGroupBox *packetoptions;
 QCheckBox *packet;        // -packet packet writing mode
 QLabel    *packetsizelabel;
 QLineEdit *packetsize;    // -pktsize=# set packetsize
 QCheckBox *noclose;        // -noclose

//CD-RW
 QButtonGroup *blankoption; //option group:blank= (all, fast,track,unreserve,trtail,unclose,session)
 QRadioButton *blankall;
 QRadioButton *blankfast;
 QRadioButton *blanktrack;
 QRadioButton *blankunreserve;
 QRadioButton *blanktrtail;
 QRadioButton *blankunclose;
 QRadioButton *blanksession;
 QPushButton  *blank;

//record group
 QLabel *progresslabel;
 QGroupBox *recgroup;
 QCheckBox *bootablecd;
 QCheckBox *onthefly;
 QPushButton *record;
 QPushButton *copy;

//image group
 QLineEdit *imagepath;
 KButton   *bimagepath;
QGroupBox *imagegroup;
QPushButton *cddata2image;
QPushButton *data2image;
QLabel *imgpath;

//working dir group
QGroupBox *workdirgroup;
QLineEdit *workdir;
KButton   *bworkdir;

//recording dialog
KDialog *recdialog;
//combobox
QGroupBox *modegroup;
QCheckBox *automode;
QCheckBox *lastsession;
QLabel *progresstext;
QPushButton *okbutton;
QPushButton *cancelbutton;

KCombo *trackmode;
KCombo *cdextra;

/*
QCheckBox *audio;      //  -audio          Subsequent tracks are CD-DA audio tracks
QCheckBox  *data;    //  -data           Subsequent tracks are CD-ROM data mode 1 (default)
QCheckBox  *mode2;    //  -mode2          Subsequent tracks are CD-ROM data mode 2
QCheckBox   *xa1;   //  -xa1            Subsequent tracks are CD-ROM XA mode 1
QCheckBox   *xa2;   //  -xa2            Subsequent tracks are CD-ROM XA mode 2
QCheckBox   *cdi;   //  -cdi            Subsequent tracks are CDI tracks
*/
//*************************
//cdda2wav interface
ECheckList *echecklist;
KButton *reload;
KButton *audio2disk;
QLabel *labeltracks;
QLabel *playtime;
QPixmap *pixreload;
QPixmap *pix2disk;
QCheckBox *cdparacheck;

//progress dialog
KDialog *progressdialog;
KProgress *imgprogress;
QPushButton *cancelshell;
QLabel  *status;

bool finddubel(KPath path, QString filename);
void getsubfiles(QDir d, KPath path, bool rootlevel);
void getsubdirs(QDir d, KPath path, bool rootlevel);
void scsiInfo();
void writercheck();
bool checkpathname(QLineEdit *path);
QString getdevstring(QString devname);
QStrList* getScsiReaderName();
QStrList* getScsiWriterName();
QString  getdirsfiles();
QString  getmkisofsparams();
QString  getcdrecordparams();
QString  getscdbname();
QString  getscdrname();
QString  getText(QString buffer);
int getProgress(QString buffer);
int getFifo(QString buffer);
void recording(bool multisession);
void makeemptyimage();
void recordcdextra();
void RecordCdPlus();
void getreadermsinfo();
QString getblanktype();
void insertDataItem(QString Url);
void insertAudioItem(QString Url);
 /** read the app-specific options on init() or by an Options dialog */
  void readOptions();

QStrList *cdblist;
QStrList *cdrlist;
QStrList *Readers;
QString *cdrom;
  public slots:
    /** put the marked text/object into the clipboard and remove 
     *	it from the document */
    void slotEditCut(); 
    /** put the marked text/object into the clipboard*/
    void slotEditCopy(); 
    /** paste the clipboard into the document*/
    void slotEditPaste();
    //Page Selected
    void slotTabSelection(int pagenumber);
    //somethng was dropped
    void slotDropData(KDNDDropZone *);
    void slotDropAudio(KDNDDropZone *);


    void slotPathChange(const char *path);

    void slotAudioSelected(int index);
    void slotDataSelected(int index);
    void slotBootCatalog();
    void slotEltorito();
    void slotImagePath();
    void slotFsCombo(int index);
    void slotShell1(KProcess* proc,char *buffer, int buflen);
    void slotShell2(KProcess* proc,char *buffer, int buflen);
    void slotShell3(KProcess* proc,char *buffer, int buflen);
    void slotCdCheckShell(KProcess* proc, char* buffer, int buflen);
    void slotWriteAudioShell(KProcess* proc,char* buffer,int buflen);
    void slotGetTracks(KProcess* proc,char* buffer ,int buflen);
    void slotMsInfo(KProcess* proc,char* buffer,int buflen);
    void slotMsInfoReader(KProcess* proc,char* buffer,int buflen);
    void slotLoadTracksCdda(KProcess* proc,char* buffer,int buflen);
    void slotLoadTracksPara(KProcess* proc,char* buffer,int buflen);
    void slotAutomode(bool on);
    void slotOkButton();
    void slotCopy();
    void slotBlank();
    void slotCancelButton();

    void slotCD2Image();
    void slotData2Image();
    void slotRecord();
    void slotCatCd2ImageShell(KProcess* proc);
    void slotMakeImageShell(KProcess *proc);
    void slotExitLoadTracks(KProcess *proc);
    void slotBlankExit(KProcess* proc);
    void slotShellExit(KProcess* proc);
    void slotBurnExit(KProcess* proc);
    void slotCdExtraExit(KProcess* proc);
    void slotSysinfoExit(KProcess*);
    void slotTextChangevid(const char* text);
    void slotTextChangepuid(const char* text);
    void slotTextChangepid(const char* text);
    void slotTextChangeaid(const char* text);
    void slotAudio2Disk();
    void slotReload();
    void slottimeout();
 protected:
  /** resizeEvent for the main view */
  virtual void resizeEvent(QResizeEvent *evt);


 private:

  ////////////////////////////////////////////////////////
  // TODO: Add your individual application widgets here

};


#endif // KEASYCDVIEW_H 




















































