/**********************************************************************

	--- Qt Architect generated file ---

	File: OptionsExtensions.cpp
	Last generated: Fri Feb 19 21:01:44 1999

	DO NOT EDIT!!!  This file will be automatically
	regenerated by qtarch.  All changes will be lost.

 *********************************************************************/

#include "OptionsExtensions.h"
#include "MimeDlg.h"
#include <iostream.h>
#include <kapp.h>

#define Inherited QWidget


OptionsExtensions::OptionsExtensions
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name, 0 )
{
	NewButton = new QPushButton( this, "NewButton" );
	NewButton->setGeometry( 260, 30, 80, 30 );
	NewButton->setMinimumSize( 10, 10 );
	NewButton->setMaximumSize( 32767, 32767 );
	NewButton->setText( i18n("New") );
	NewButton->setAutoRepeat( FALSE );
	NewButton->setAutoResize( FALSE );
	connect(NewButton,SIGNAL(clicked()),SLOT(newClicked()));

	DeleteButton = new QPushButton( this, "DeleteButton" );
	DeleteButton->setGeometry( 260, 85, 80, 30 );
	DeleteButton->setMinimumSize( 10, 10 );
	DeleteButton->setMaximumSize( 32767, 32767 );
	DeleteButton->setText( i18n("Delete") );
	DeleteButton->setAutoRepeat( FALSE );
	DeleteButton->setAutoResize( FALSE );
	connect(DeleteButton,SIGNAL(clicked()),SLOT(deleteClicked()));

	EditButton = new QPushButton( this, "EditButton" );
	EditButton->setGeometry( 260, 140, 80, 30 );
	EditButton->setMinimumSize( 10, 10 );
	EditButton->setMaximumSize( 32767, 32767 );
	EditButton->setText( i18n("Edit") );
	EditButton->setAutoRepeat( FALSE );
	EditButton->setAutoResize( FALSE );
	connect(EditButton,SIGNAL(clicked()),SLOT(editClicked()));

	ListView = new QListView(this);
	ListView->addColumn(i18n("Name"),150);
	ListView->addColumn(i18n("Extensions"),100);
	ListView->setGeometry(30,30,200,180);
	ListView->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	ListView->setLineWidth(2);
	ExtList = 0;
	Loader = 0;
	Modified = FALSE;

	resize( 390,235 );
	setMinimumSize( 0, 0 );
	setMaximumSize( 32767, 32767 );
}


OptionsExtensions::~OptionsExtensions()
{
}

void OptionsExtensions::setExtList(KMimeExtList *list, KPIconLoader *IL, bool UseKDEMimeTypes)
{
	ExtList = list;
	Loader = IL;
	CanModify = !UseKDEMimeTypes;
	ListView->clear();
	KMimeExtListIterator	it(*ExtList);
	QListViewItem	*item;
	for (;it.current();++it) {
		QString		ext;
		QStrListIterator	it2(it.current()->Extensions);
		for (;it2.current();++it2) {ext += it2.current(); ext += ";";}
		item = new QListViewItem(ListView,it.current()->Description.data(),ext.data());
		item->setPixmap(0,*(Loader->loadMiniIcon(it.current()->MimeIcon.data())));
	}
	NewButton->setEnabled(CanModify);
	DeleteButton->setEnabled(CanModify);
}

KMimeExtension* OptionsExtensions::findExtension(QListViewItem *item)
{
	if (item == 0) return 0;
	KMimeExtListIterator	it(*ExtList);
	for (;it.current();++it) if (it.current()->Description == item->text(0)) break;
	return it.current();
}

void OptionsExtensions::newClicked()
{
	MimeDlg	*Dlg = new MimeDlg(0,FALSE,this);
	if (Dlg->exec()) {
		KMimeExtension	*ext = new KMimeExtension(Dlg->MimeName->text(),Dlg->Extensions->text(),(Dlg->Application->text() == 0 ? "None" : Dlg->Application->text()),Dlg->Description->text(),Dlg->Icon->text(),Dlg->InShell->isChecked());
		ExtList->append(ext);
		Modified = TRUE;
		emit needApplyOptions();
	}
}

void OptionsExtensions::deleteClicked()
{
	KMimeExtension	*ext = findExtension(ListView->currentItem());
	if (ext == 0) return;
	ExtList->removeRef(ext);
	Modified = TRUE;
	emit needApplyOptions();
}

void OptionsExtensions::editClicked()
{
	KMimeExtension	*ext = findExtension(ListView->currentItem());
	if (ext == 0) return;
	if (FALSE) {		// KDE mime types
		KProcess	*p = new KProcess;
		connect(p,SIGNAL(processExited(KProcess*)),SLOT(processExited(KProcess*)));
		(*p) << "kfmclient" << "openProperties" << ext->FileName.data();
		p->start();
		return;
	}
	MimeDlg	*Dlg = new MimeDlg(ext,!CanModify,this);
	if (Dlg->exec()) {
		if (Dlg->Application->text() != ext->Application) { Modified = TRUE; ext->Application = Dlg->Application->text();}
		if (Dlg->Description->text() != ext->Description) { Modified = TRUE; ext->Description = Dlg->Description->text();}
		if (Dlg->Icon->text() != ext->MimeIcon) { Modified = TRUE; ext->MimeIcon = Dlg->Icon->text();}
		if (Dlg->MimeName->text() != ext->MimeName) { Modified = TRUE; ext->MimeName = Dlg->MimeName->text();}
		if (Dlg->FileName->text() != ext->FileName) { Modified = TRUE; ext->FileName = Dlg->FileName->text();}
		if (Dlg->InShell->isChecked() != ext->inShell) { Modified = TRUE; ext->inShell = Dlg->InShell->isChecked();}
		QString		tmp;
		QStrListIterator	it(ext->Extensions);
		for (;it.current();++it) {tmp += it.current(); tmp += ";";}
		if (Dlg->Extensions->text() != tmp) {
			Modified = TRUE;
			tmp = Dlg->Extensions->text();
			ext->Extensions.clear();
			char	*c = strtok(tmp.data(),";");
			while (c) {
				ext->Extensions.append(c);
				c = strtok(0,";");
			}
		}
	}
	delete Dlg;
}

void OptionsExtensions::processExited(KProcess *p)
{
	if (p->normalExit()) emit needApplyOptions(), cout << p->exitStatus() << endl;
	delete p;
}
