#ifndef _DEVICE_H_
#define _DEVICE_H_

#include "protocol.h"
#include "mountprot.h"

class Device
{
public:
	Device(const char *name, const char *icon, Protocol *prot, bool keep, const char *str1, const char *str2, const char *str3, const char *str4, const char *str5);
	~Device() {}

	int type() { return Prot->type();}
	QString name() { return Name;}
	QString icon() { return DevIcon;}
	Protocol* protocol() { return Prot;}
	bool keep() { return Keep;}
	QString string(int i) { return Str[i];}
	QString path();

private:
	QString		Name;
	QString		DevIcon;
	Protocol	*Prot;
	bool		Keep;
	QString	Str[5];
};

inline Device::Device(const char *name, const char *icon, Protocol *prot, bool keep, const char *str1, const char *str2, const char *str3, const char *str4, const char *str5)
	: Name(name), DevIcon(icon), Prot(prot), Keep(keep)
{
	Str[0] = str1;
	Str[1] = str2;
	Str[2] = str3;
	Str[3] = str4;
	Str[4] = str5;
}

inline QString Device::path()
{
	QString		tmp;
	switch (type()) {
	   case Protocol::Trash:
	   case Protocol::File:
		tmp = ("file:" + Str[0]);
		break;
	   case Protocol::Mount:
		tmp = "file:";
		tmp += ((MountProtocol*)Prot)->mountp();
		break;
	   case Protocol::Ftp:
		tmp = "ftp://";
		if (!Str[2].isEmpty()) {
			tmp += Str[2];
//			if (!Str[3].isEmpty()) tmp += (":" + Str[3]);
			tmp += "@";
		}
		tmp += Str[0];
		if (!Str[4].isEmpty()) {
			tmp += ':';
			tmp += Str[4];
		}
		tmp += Str[1];
		break;
	}
	if (tmp[tmp.length()-1] != '/') tmp += "/";
	return tmp;
}

#endif

