#ifndef _KEXPLORER_H_
#define _KEXPLORER_H_

#include <ktmainwindow.h>
#include <qsplitter.h>
#include <qstrlist.h>
#include <qlabel.h>
#include <kapp.h>
#include <device.h>
#include "dirview.h"
#include "kflistbase.h"
#include "ksiconlist.h"
#include "kbiconlist.h"
#include "kdetaillist.h"
#include "kpiconloader.h"
#include "fileinfo.h"
#include "kfixpanner.h"
#include "dircombo.h"
#include "protmgr.h"
#include "kmime.h"
#include "mimemagic.h"
#include "filter.h"
#include "kfilehdr.h"
#include "Options.h"

class KExplorer : public KTMainWindow
{
	Q_OBJECT;

public:
	KExplorer(const char *path = 0, QWidget *parent = 0, const char *name = 0, WFlags f = 0);
	~KExplorer();

	void catchSignal(int sig);

protected:
	void setupMenu();
	void setupToolBar();
	void loadConfiguration();
	void saveConfiguration();
	void loadDevices();
	void saveDevices();
	void setupMimeTypes();
	void saveMimeTypes();
	void scanMimeDir(const QString& dir);
	void scanAppLnkDir(const QString& dir);
	void initBusy();
	void finishBusy();
	void destroyFileView();
	void createFileView();
	void resortFileList();
	Device* findDevice(const char *name);
	Device* findDevice(Protocol*);
	void executeAction(const char *cmd, KURL& url);
	void removeURLs();
	Device* findTrash();
	void listDevices(bool local);
	void listDesktop();
	Protocol* createArchiveProtocol(KURL& url);
	void goToDir(KURL& url);
	bool createXVPICSDir(KURL& url);

protected slots:
	void mainCallback();
	void scanDirectory(DirViewItem *item);
	void scanSubDirectories(DirViewItem *item);
	void bigIcons();
	void listIcons();
	void smallIcons();
	void detailIcons();
	void openItem(FileInfo*);
	void columnPressed(int col);		// in detail mode
	void listByName();
	void listBySize();
	void listByType();
	void listByDate();
	void cut();
	void copy();
	void paste();
	void remove();
	void property();
	void newDevice();
	void removeDevice();
	void shutdown();
	void toggleToolBar();
	void toggleStatusBar();
	void popupFileView();
	void openThisItem();
	void removeThisDevice();
	void edit();
	void menuActivated(int);
	void popupDirectoryTree(DirViewItem*);
	void explore();
	void expand();
	void collapse();
	void newDir();
	void openTerminal();
	void openWith();
	void launchFind();
	void dropOnTree(QDropEvent *e, DirViewItem *item);
	void copyDrag();
	void moveDrag();
	void linkDrag();
	void toggleShowHidden();
	void abort();
	void options();
	void optionsApply();
	void refresh();
	void selectionChanged();
	void renameItem(FileInfo*, const QString&);
	void mount();
	void umount();
	void moveToTrash();
	void emptyTrash();
	void removeThisFolder();
	void propertyThisFolder();
	void updateHasChilds(DirViewItem *item);
	void refreshDir();
	void toggleShowMiniImages();
	void toggleShowArchive();
	void miniImageRequested(FileInfo*);
	void openArchive();
	void selectOutdatedThumbnails();
	void goToDir();

private:
	// Widgets
	QSplitter	*MainView;
	KFixPanner	*RightView;
	KFixPanner	*LeftView;
	KFileListBase	*FileView;
	DirView		*DirectoryTree;
	KPIconLoader	*IconLoader;
	KToolBar	*ToolBar;
	KMenuBar	*MenuBar;
	KStatusBar	*StatusBar;
	QLabel		*RightViewInfo;
	QLabel		*LeftViewInfo;
	DirCombo	*Combo;
	KFileHeader	*FileHeader;
	KFixPanner	*RightSubView;
	QPopupMenu	*Pop1;
	QPopupMenu	*Pop2;
	QPopupMenu	*Pop3;
	QPopupMenu	*Pop4;
	Options		*OptionsDlg;
	QLabel		*Status1Info;
	QLabel		*Status2Info;

	// Components
	FileInfoList	*FileList;
	KConfig		*ConfigFile;
	QList<Device>	DeviceList;
	ProtocolMgr	*Manager;
	KMimeExtList	*ExtensionList;
	KMimeAppList	*ApplicationList;
	KMimeExtDict	*ExtensionDict;
	KMimeExtList	*FilenameDict;
	KMimeAppDict	*ApplicationDict;
	MimeMagic	*Magic;
	Filter		*MainFilter;
	QStrList	URLList;
	bool		Cutted;
	DirViewItem	*TmpItem;
	DirViewItem	*TmpDevice;
	FileInfo	*TmpFile;
	bool		Busy;
	SubProtList	*ProtList;

	// Config elements
	bool		UseKDEIcons;
	bool		UseKDEMimeTypes;
	bool		UseMagicNumbers;
	QString		IconPath;
	QString		MagicFile;
	QString		ExtensionFile;
	int		Style;
	int		Sorting;
	bool		ToolBarEnabled;
	bool		StatusBarEnabled;
	bool		ShowHiddenFiles;
	int		SavedWidth;
	int		SavedHeight;
	int		SavedDirWidth;
	QString		ColName[5];
	QStrList	ColType;
	QStrList	ColWidth;
	int		DateFormat;
	bool		ShowArchive;
	bool		ShowMiniImages;
	int		MiniImageSaving;
	int		ImageSize;
	QString		Shell;
	QString		LastPath;
	int		StartupDir;
};

inline void KExplorer::explore()
{ DirectoryTree->setCurrentItem(DirectoryTree->popupItem());}

inline void KExplorer::expand()
{ DirectoryTree->expandItem(DirectoryTree->popupItem());}

inline void KExplorer::collapse()
{ DirectoryTree->collapseItem(DirectoryTree->popupItem());}

inline void KExplorer::abort()
{ Manager->abort();}

inline void KExplorer::refreshDir()
{ DirectoryTree->rescanChilds(DirectoryTree->popupItem());}

#endif
