#ifndef _PROTMGR_H_
#define _PROTMGR_H_

#include <qlist.h>
#include <qstrlist.h>
#include "ProgressDlg.h"
//#include <qprogressdialog.h>
#include <qwidget.h>
#include "protocol.h"

class ProtocolMgr
{
public:
	ProtocolMgr(QWidget *parent = 0);
	~ProtocolMgr();
//	void setParentWidget(QWidget *parent);
	void setupMime(KMimeExtDict *extDict = 0, KMimeExtList *nameDict = 0, MimeMagic *magic = 0, bool use = TRUE);
	void setupSubProtList(SubProtList *list = 0);
	ProgressDlg* progress();
	bool emptyTrash(Protocol*);

	Protocol* createProtocol(int type, const char *str1 = 0, const char *str2 = 0, const char * str3 = 0, const char *str4 = 0, const char *str5 = 0);
	Protocol* createProtocol(KURL& url);
	void deleteProtocol(KURL& url);
	void deleteProtocol(Protocol *prot);
	Protocol* searchProtocol(const KURL& url);
	bool transfer(const char *src, const char *dest, bool needHide = TRUE, bool move = FALSE);
//	bool copy(Protocol *protSrc, const char *src, Protocol *protDest, const char *dest, bool needHide = TRUE);
	bool copy(const QStrList& src, const char *dest);
//	bool copy(const QStrList& src, Protocol *prot, const char *destDir);
//	bool move(const char *src, const char *dest, bool needHide = TRUE);
	bool move(const QStrList& src, const char *dest);
	const char* getFile(const char *filename);
	const char* getFile(Protocol* prot, KURL& url);
	const FileInfoList* list(Protocol *prot, KURL& url, bool hidden, bool dirsOnly = FALSE, bool showArchive = FALSE);
	const FileInfoList* list(const char *url, bool hidden, bool dirsOnly = FALSE, bool showArchive = FALSE);
	const FileInfoList* listSubDirs(Protocol *prot, KURL& url, bool hidden, bool showArchive = FALSE);
	const FileInfoList* listSubDirs(const char *url, bool hidden, bool showArchive = FALSE);
	bool rename(Protocol *prot, const KURL& src, const KURL& dest);
	bool rename(const char *src, const char *dest);
	bool remove(Protocol *prot, const KURL& url);
	bool remove(const char *url);
	bool rmdir(Protocol *prot, const KURL& url);
	bool rmdir(const char *url);
	bool chmod(Protocol *prot, const KURL& url, int perm);
	bool chmod(const char *url, int perm);
	bool mkdir(Protocol *prot,const KURL& url);
	bool mkdir(const char *url);

	void abort();

private:
	QList<Protocol>		*protList;
	QStrList		*tmpList;
	Protocol		*activeProtocol;
	QWidget		*ParentWidget;
	bool		askOverwrite;
	ProgressDlg		*dlg;
	KMimeExtDict		*ExtDict;
	KMimeExtList		*NameDict;
	KMimeAppList		*AppList;
	MimeMagic		*Magic;
	bool			UseMagic;
	SubProtList		*subProtList;
};

/*inline void ProtocolMgr::setParentWidget(QWidget *parent)
{
	ParentWidget = parent;
}*/

inline const FileInfoList* ProtocolMgr::listSubDirs(Protocol *prot, KURL& url, bool hidden, bool showArchive)
{
	return list(prot,url,hidden,TRUE,showArchive);
}

inline const FileInfoList* ProtocolMgr::listSubDirs(const char *url, bool hidden, bool showArchive)
{
	return list(url,hidden,TRUE,showArchive);
}

inline ProgressDlg* ProtocolMgr::progress()
{ return dlg;}

#endif

