#include "Verzeichnis.h"


#define Kommentar
/*
extern QPixmap *DirPixMap;
extern QPixmap *OpenDirPixMap;
extern QPixmap *CDPixMap;
*/

extern time_t        aktZeit;
extern unsigned char cursArt;

T_Verzeichnis::T_Verzeichnis()
{
  Groesse = 0;
  GroesseII = 0;
  GesamtGroesse = 0;
}

int T_Verzeichnis::Setzen(string iPfad, bool FollowSymLink)
{
  // Rekursiv wird jetzt das eigene Verzeichnis und alle Unterverzeichnisse
  // eingelesen.
  // die Informationen der Struktur "dirent" scheinen keine verlssliche Aussage
  // zu machen, ob es sich um eine Datei oder ein Verzeichnis handelt und hnliche
  // Dinge; man mu das also extra ermitteln.
  // Auch mu man dann unterschiedlich die Dateiattribute ermitteln-je nachdem,
  // wie man auch mkisofs aufruft; wenn man es mit "-f" aufruft, folgt es dem Link
  // und bindet die gelinkte Datei ein. In diesem Fall muss man die Dateiattribute 
  // mit "stat" ermitteln. Ruft man mkisofs ohne "-f" auf, muss man sie mit "lstat"
  // abfragen.

  DIR*            Verz;                 // der VerzeichnisStrom
  dirent*         VerzEintr;            // hier werden die Daten aus obigem gegeben
  struct stat     Attribs;              // ein Puffer fr die Dateiattribute

  time_t          neuZeit;

  Groesse   = 0;  
  GroesseII = 0;
  Name = iPfad;

  time(&neuZeit);
  if (aktZeit != neuZeit)
    {
      // ein Lebenszeichen geben

      QApplication::restoreOverrideCursor(); 

      switch (++cursArt)
	{
	case 2: QApplication::setOverrideCursor(sizeBDiagCursor); break;
	case 4: QApplication::setOverrideCursor(sizeVerCursor);   break;
	case 6: QApplication::setOverrideCursor(sizeFDiagCursor); break;
	case 8: 
	  QApplication::setOverrideCursor(sizeHorCursor);   
	  cursArt=0;
 	  break;
	default: QApplication::setOverrideCursor(waitCursor);
	}
      
      aktZeit = neuZeit;
    }

  if (iPfad == "dummydir") return(0);
  
  Verz = opendir(Name.c_str());
  if (Verz != 0) {
    VerzEintr = new dirent;
    
    while ((VerzEintr = readdir(Verz)) != NULL) 
      {
	//	cout << "readdir gibt mir: " << VerzEintr->d_name << "\n";
	{
	  string tmp = Name;
	  
	  tmp += VerzEintr->d_name;
	  if (FollowSymLink) stat(tmp.c_str(), &Attribs); 
	  else lstat(tmp.c_str(), &Attribs); 
	}
	
	if (S_ISDIR(Attribs.st_mode) != 0) 
	  {
	    // Es ist ein Verzeichnis!
	    string tmp = VerzEintr->d_name;
	    
	    if ((tmp != "..") && (tmp != "."))
	      {
		tmp += "/";
		
		UnterVerz.push_back(new T_Verzeichnis);
		UnterVerz[UnterVerz.size()-1]->Setzen(Name+tmp, FollowSymLink);
	      }
	  }
	if (S_ISREG(Attribs.st_mode) != 0) 
	  {
	    // Es ist eine Datei! (oder auch ein verfolgtes Link... s.o.)
	    T_VerzEintraege NichtVerz;            // ein Puffer

	    NichtVerz.DateiName = VerzEintr->d_name;
	    NichtVerz.Groesse = Attribs.st_size;
	    Dateien.push_back(NichtVerz);  
	    Groesse += Attribs.st_size;
	  }
      }
    delete VerzEintr;
    closedir(Verz);
    return(0);
  }
  else 
    {
      string tmp = i18n("unable to open dir:\n") + Name;
      fehlermeldung((char *)tmp.c_str());
      return(-1);
    }
}
  
int T_Verzeichnis::SetzenD(string iFile, string oFile, bool FollowSymLink)
  // ldt nur eine einzige Datei in den Speicher
{
  struct stat     Attribs;              // ein Puffer fr die Dateiattribute
  T_VerzEintraege NichtVerz;            // ein Puffer
  string          orgDatName;
  
  
  //  cerr << iFile << "->" << oFile << "\n";
  
  
  
  if (oFile[oFile.length()-1] == '/') NichtVerz.DateiName = iFile;
  else 
    {
      NichtVerz.DateiName = oFile;
      orgDatName = iFile;
      while (orgDatName.find("/") != string::npos) orgDatName.replace(0, 1, "");
    }
  
  while (NichtVerz.DateiName.find("/") != string::npos) 
    NichtVerz.DateiName.replace(0, 1, "");
  
  if (oFile[oFile.length()-1] != '/') NichtVerz.quellName +=  orgDatName;
  else NichtVerz.quellName = "";
  
  
  Name = iFile;
  while (Name[Name.length()-1] != '/') 
    Name.replace(Name.length()-1, 1, "");
  

  

  //  cerr << "Name: " << Name << "\n";


  if (FollowSymLink) stat(iFile.c_str(), &Attribs); 
  else lstat(iFile.c_str(), &Attribs);
  // es muss noch getestet werden, weil es sein kann, dass der bergebene Pfad
  // auf ein symbolisches Link zeigt, diese aber nicht verfolgt werden sollen!
  if (S_ISREG(Attribs.st_mode) != 0) 
    {
      NichtVerz.Groesse = Attribs.st_size;
      Dateien.push_back(NichtVerz);  
      Groesse = Attribs.st_size;
      return(0);
    }
  else return(-1);
}

unsigned long T_Verzeichnis::GetSizeR()
{
  GesamtGroesse = GroesseII;

  // Die GesamtGrsse meiner Unterverzeichnisse abfragen und aufaddieren:
  for (unsigned int Cnt = 0; Cnt < UnterVerz.size(); Cnt++) 
    {
      GesamtGroesse += UnterVerz[Cnt]->GetSizeR();
    }
  return(GesamtGroesse);
}

unsigned long T_Verzeichnis::GetSize()
{
  return(GroesseII);
}

void T_Verzeichnis::calcSize(vector<string> Excl)
{
  // eigene Gre berechnen
  GroesseII = Groesse;
  bool fAusschluss = false;


  // wenn einer der Ausschluss-Pfade in meinem "Name" vorhanden ist, kann
  // ich mich gleich beenden:
  for (unsigned int Cnt = 0; Cnt < Excl.size(); Cnt++) {
    if (Excl[Cnt][0] == '/') 
      if (Name.find(Excl[Cnt]) == 0) { fAusschluss = true; }
  }
  // Jetzt mu ich jeden Abschnitt meines Pfades nehmen und prfen lassen,
  // ob eines der Ausschlussmuster auf einen der Abschnitte pat--wenn das
  // so ist, kann ich mich wiederum gleich beenden:
  {
    string tmpQuell = Name;

    // Fhrenden Slash lschen:
    tmpQuell.replace(0, 1, "");
    // Jetzt immer den SubString vom Stringanfang bis zum nchsten Slash (das
    // ist ein Pfadabschnitt) durch die Mustererkennung schicken:
    while (tmpQuell.find("/") != string::npos) {
      if (ausschlussTrifft(tmpQuell.substr(0, tmpQuell.find("/")), Excl)) {
	fAusschluss = true;
      }
      tmpQuell.replace(0, tmpQuell.find("/")+1, "");
    }
  }
  // wenn fAusschluss jetzt noch false ist, knnte es immerhin sein, dass meine
  // Dateien nicht ausgeschlossen werden. Diese gehe ich jetzt einfach nach und nach durch,
  // die Grsse jeder ausgeschlossenen ziehe ich von GroesseII ab.
  if (fAusschluss) { 
    GroesseII = 0;
  }
  else {
    for (unsigned int Cnt = 0; Cnt < Dateien.size(); Cnt++) {
      if (ausschlussTrifft(Dateien[Cnt].DateiName, Excl)) {
	GroesseII -= Dateien[Cnt].Groesse;
      }
    }
  }

  // Die Unterverzeichnisse sollen das auch tun:
  for (unsigned int Cnt = 0; Cnt < UnterVerz.size(); Cnt++) {
    UnterVerz[Cnt]->calcSize(Excl);
  }
}

int T_Verzeichnis::fillTreeList(QListView* ktl, 
				string SrcPath, 
				string DstPath,
				vector<string> Excl,
				ofstream &dat)
{
  string QuellPfad = SrcPath;
  
  if (SrcPath != "dummydir")
    {  
      // wenn ich den Auftrag habe, nur eine Datei zu speichern, hngt in dem
      // SrcPath, den ich jetzt bekommen habe, noch der Dateiname drin.
      // Da der den Algo nur durcheinanderbringen wrde, wird er hier gelscht:
      while (QuellPfad[QuellPfad.size()-1] != '/') 
	QuellPfad.replace(QuellPfad.size()-1, 1, "");
      
      
      // wenn einer der Ausschluss-Pfade in meinem "Name" vorhanden ist, kann
      // ich mich gleich beenden:
      for (unsigned int Cnt = 0; Cnt < Excl.size(); Cnt++) 
	if (Excl[Cnt][0] == '/') 
	  if (Name.find(Excl[Cnt]) == 0) 
	    {
	      cout << "Ausgeschlossen (Verz und drunter, durch Verzangabe): " 
		   << Name << "\n";
	      return(0);
	    }
    
  
      // Jetzt mu ich jeden Abschnitt meines Pfades nehmen und prfen lassen,
      // ob eines der Ausschlussmuster auf einen der Abschnitte pat--wenn das
      // so ist, kann ich mich wiederum gleich beenden:
      {
	string tmpQuell = Name;
	
	// Fhrenden Slash lschen:
	tmpQuell.replace(0, 1, "");
	// Jetzt immer den SubString vom Stringanfang bis zum nchsten Slash (das
	// ist ein Pfadabschnitt) durch die Mustererkennung schicken:
	while (tmpQuell.find("/") != string::npos) {
	  if (ausschlussTrifft(tmpQuell.substr(0, tmpQuell.find("/")), Excl)) {
	    cout << "Ausgeschlossen (Verz und drunter, durch Muster): "
		 << Name << "\n";
	    return(0);
	  }
	  tmpQuell.replace(0, tmpQuell.find("/")+1, "");
	}
      }
    }

      
  // DstPath muss angelegt werden, nein genauer:
  // vom "Name" muss ich vorne "QuellPfad" abziehen und stattdessen "DstPath" dranhngen.
  // Der dabei entstehende String muss angelegt werden.
  // auerdem merke ich mir den als "meinPlatz", damit ich spter auf Anhieb weiss,
  // ob ich in ein Unterverzeichnis gehre oder nicht.
  meinPlatz = Name;
  
  // Wenn DstPath nicht mit einem "/" aufhrt, was der Fall ist, wenn es eine einzelne
  // Datei ist, die unter anderem Namen auf der CD landet, muss ich diesen Namen fr die 
  // folgende Aktion hinten abziehen, denn es sollen ja nur die Verzeichnisse erstellt 
  // werden:

  string DstPath2 = DstPath;

  while (DstPath2[DstPath2.length()-1] != '/') DstPath2.replace(DstPath2.length()-1, 1, "");
  
  //  cerr << "neuer DstPath: " << DstPath << "\n";

  
  meinPlatz.replace(0, QuellPfad.length(), DstPath2);
  createPathItems(ktl, meinPlatz);  // in tools.h.....

  if (Name != "dummydir") 
    {
      string meinNeuPlatz = meinPlatz;
      meinNeuPlatz.replace(0, 3, "$V\"");
      dat << "mkdir -p " << meinNeuPlatz << "\"\n";
    }
 
  // Die Unterverzeichnisse aufrufen, damit sie dasselbe tun...
  for (unsigned int Cnt = 0; Cnt < UnterVerz.size(); Cnt++)
    UnterVerz[Cnt]->fillTreeList(ktl, QuellPfad, DstPath2, Excl, dat);

  return(0);
}

void T_Verzeichnis::zeigInhalt(unsigned long*    size, 
			       unsigned long*    sizeR,
			       string            ZielPfad, 
			       QListView*        DatList, 
			       vector<string>    Excl)
{
  // Wenn ich dazu gehre, unter meinem Namen meine Dateien ausgeben:
  if (ZielPfad.compare(meinPlatz) == 0 && Name != "dummydir") 
    {
      string tmp;
      for (unsigned int Cnt = 0; Cnt < Dateien.size(); Cnt++) 	
	if (!ausschlussTrifft(Dateien[Cnt].DateiName, Excl)) 
	  {
	    tmp = Name;
	    if (Dateien[Cnt].quellName.length() != 0) tmp += Dateien[Cnt].quellName;
	    else tmp += Dateien[Cnt].DateiName;
	    new QListViewItem(DatList,
	                      Dateien[Cnt].DateiName.c_str(),
			      itoStr(Dateien[Cnt].Groesse, ' ', 4).c_str(),
			      tmp.c_str());
	  }
	else 	  
	  cout << "DateiAusschluss: " << Dateien[Cnt].DateiName << " in " 
	       << Name << "\n";
      	
      *size  += GroesseII;
      *sizeR += GesamtGroesse;
    } 
  else 
    {
      // Die Unterverzeichnisse aufrufen, damit sie dasselbe tun...
      for (unsigned int Cnt = 0; Cnt < UnterVerz.size(); Cnt++) 
	UnterVerz[Cnt]->zeigInhalt(size, sizeR, ZielPfad, DatList, Excl);      
      
      // wenn ich UNTER dem ZielPfad liege, muss ich auch die Gre meiner
      // Dateien dazutun:
      // darunter liegen bedeutet: ZielPfad ist in MeinPlatz enthalten, stellt
      // das obere Ende dar.
      if (meinPlatz.find(ZielPfad) == 0) *sizeR += GroesseII; 
    }
}


int T_Verzeichnis::erstellListe(ofstream          &dat, 
				vector<string>    Excl,
				unsigned long int &cnt)
{
  // unter meinem Namen meine Dateien ausgeben:
  if (Name != "dummydir") 
    {
      bool   fD = true;
      string meinNeuPlatz = meinPlatz;

      meinNeuPlatz.replace(0, 3, "");
      
      dat << "P=\"" << meinNeuPlatz << "\"\n";

      for (unsigned int Cnt = 0; Cnt < Dateien.size(); Cnt++) 	
	if (!ausschlussTrifft(Dateien[Cnt].DateiName, Excl)) 
	  {
	    if (fD)
	      {
		dat << "D=$V$P\n";		    
		fD = false;
	      }
	    dat << "S=\"" << Name;
	    if (Dateien[Cnt].quellName.length() != 0) 
	      {
		dat << Dateien[Cnt].quellName;
		dat << "\"\nD=$V$P\"" << Dateien[Cnt].DateiName << "\"\n";
		fD = true;
	      }
	    else 
	      {
		dat << Dateien[Cnt].DateiName << "\"\n";
	      }
	    
	    if (cnt % 30 == 0) 
	      {
		if (cnt == 1800) 
		  {
		    dat << "l_pn\n";
		    cnt = 0;
		  }
		else dat << "l_p\n";
	      }
	    else dat << "l\n";
	    cnt++;
	  }
    } 
  // Die Unterverzeichnisse aufrufen, damit sie dasselbe tun...
  for (unsigned int Cnt = 0; Cnt < UnterVerz.size(); Cnt++) 
    UnterVerz[Cnt]->erstellListe(dat, Excl, cnt);      

  return(0);
}

T_Verzeichnis::~T_Verzeichnis()
{
  // alle Unterverzeichnisse freigeben (sie sind dynamisch erzeugt!)
  for (unsigned int Cnt=0; Cnt < UnterVerz.size(); Cnt++) {
    delete UnterVerz[Cnt];
  }
}


















