#ifndef cdTree__HEADERDAT
#define cdTree__HEADERDAT

/*** C++ ***/
#include <string>
#include <vector>
#include <dirent.h>     // fr die Verzeichnisoperationen
#include <fstream.h>

/*** KisoCD ***/
#include "Verzeichnis.h"
#include "tools.h"
#include "version.h"
#include "kstatusbar.h"

struct T_cdVerz {
  string         SrcPath;  // Wo kommt das Verzeichnis her?
  string         DstPath;  // Wo soll es im Verzeichnisbaum der CD eingebaut werden?
  T_Verzeichnis* Inhalt;   // Was ist drin?
};

/**********************************************************************************
 *                                                                                *
 * class T_cdTree                                                                 *
 *                                                                                *
 **********************************************************************************
 * implementiert eine Liste aus jeweils zwei "string", beginnend bei Index= 0     *
 * mit der Anzahl xx.getVerzNum (Anzahl, nicht letzter Index!!!)                  *
 **********************************************************************************/
class T_cdTree {
private:
  vector <T_cdVerz>   VerzListe;      // Zuordnungen, wie sie mkisofs haben will
  vector <string>     Ausschluss;     // Verzeichnisse, Dateinamen oder Muster 
                                      // zum Ausschluss
  unsigned long       Gesamtgroesse;
public:
  // liefert bei ungltigem Index -1 zurck, sonst 0:
  int getVerz(unsigned int index, string &SrcPath, string &DstPath); 
  // liefert die ANZAHL der Eintrge zurck:
  int getVerzNum();
  // liefert -1 zurck, wenn dieses Eintragpaar schon vorhanden war, -2 wenn
  // das Quellverzeichnis nicht vorhanden ist, sonst 0:
  // -3, wenn die Datei ein symbolisches Link war, diese aber nicht verfolgt
  // werden sollen
  int Append(string SrcPath, string DstPath, bool FollowSymLink);
  // liefert bei ungltigem Index -1 zurck, sonst 0:
  int Remove(unsigned int index);
  // liefert -1 zurck, wenn keine Verzeichnisse eingetragen sind, sonst 0:
  int getCDVerzTree(QListView* ktl, bool Append);
  // Liefert die Gesamtgre zurck
  unsigned long getCDSize();
  // berechnet die Groessen unter Bercksichtigung der Ausschlsse
  void calcSize();
  // Zeigt den in der TreeList gewhlten Eintrag in der ListBox an
  void Zeig(KStatusBar* statBar,
	    QListView*  DatList, 
	    QListView*  ktl, 
	    string      pfad);

  bool existDestDir(string);   // true, wenn es das genannte DestDir gibt.

  // fast alle Routinen nochmal fr die Liste mit den Ausschlssen:
  int getEx(unsigned int index, string &Muster);
  int getExNum();
  int Exclude(string Muster);
  int removeEx(unsigned int index);


  int erstellListe(string dateiPfad);

  T_cdTree()
    {
      Gesamtgroesse = 0;
    };

  // ein Destruktor ist ntig, weil ja in dem vector-Element auch dynamisch
  // erzeugte T_Verzeichnis-Objekte sind, die gelscht werden mssen.
  ~T_cdTree();
};

#endif cdTree__HEADERDAT







