#include "neuVerzDiag.h"

neuVerzDiag::neuVerzDiag(QWidget *parent, 
			 const char *name, 
			 const char *GuteZeichen, 
			 const char *HilfeText,
			 string vorgabe)        
  : QDialog( parent, name, TRUE )    {

  tmpQLineEdit = new KRestrictedLine(this, "LineEdit_1", 
				     GuteZeichen);
  tmpQLineEdit->setGeometry( 30, 190, 260, 30 );
  tmpQLineEdit->setText(vorgabe.c_str());
  tmpQLineEdit->setMaxLength( 128 );
  tmpQLineEdit->setEchoMode( QLineEdit::Normal );
  tmpQLineEdit->setFrame( TRUE );
  tmpQLineEdit->setFocus();
  tmpQLineEdit->setCursorPosition(vorgabe.length());
  connect( tmpQLineEdit, SIGNAL(returnPressed()), SLOT(accept()) );


  cancel = new QPushButton( this, "PushButton_1" );
  cancel->setGeometry( 190, 240, 100, 30 );
  cancel->setText( i18n("Cancel") );
  cancel->setAutoRepeat( FALSE );
  cancel->setAutoResize( FALSE );
  connect( cancel, SIGNAL(clicked()), SLOT(reject()) );

  ok = new QPushButton( this, "PushButton_2" );
  ok->setGeometry( 30, 240, 100, 30 );
  ok->setText( i18n("OK") );
  ok->setAutoRepeat( FALSE );
  ok->setAutoResize( FALSE );
  connect( ok, SIGNAL(clicked()), SLOT(accept()) );

  tmpQLabel = new QLabel( this, "Label_1" );
  tmpQLabel->setGeometry( 30, 10, 260, 170 );
  tmpQLabel->setText(HilfeText);
  tmpQLabel->setAlignment( 1313 );
  tmpQLabel->setMargin( -1 );

  resize( 320, 290 );
  setFixedSize(320, 290);
}

neuVerzDiag::~neuVerzDiag()
{
  delete ok;
  delete cancel;
  delete tmpQLabel;
  delete tmpQLineEdit;
}

#include "neuVerzDiag.moc"










































