#ifndef __toolsXY__HEADERDAT
#define __toolsXY__HEADERDAT

/*** Qt ***/
#include <qstring.h>
#include <qlistview.h>
#include <qcursor.h>
#include <qmessagebox.h>
#include <qapplication.h>

/*** KDE ***/
#include <kapp.h>
#include <ksimpleconfig.h>
#include <kprocess.h>


/*** C++ ***/
#include <string>
#include <vector>
#include <fstream.h> 
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>

/*** KisoCD ***/
#include "version.h"
#include "types.h"


class t_fileWatch {
  struct stat fileData;
  string      aFileName;
public:
  bool        flag;
  
  bool hasChanged()
    {
      struct stat tmp;

      stat(aFileName.c_str(), &tmp);
      return(!(tmp.st_size == fileData.st_size &&
	       tmp.st_mtime == fileData.st_mtime));
    };
  
  void lookNow(string fileName)
    {
      aFileName = fileName;
      stat(fileName.c_str(), &fileData);
    };
};

class t_debugFile {
    ofstream myFile;
    string   myDir;
    string   myBaseName;
    bool     fileOpen;

    int createFile();
 public:
    t_debugFile(string dir = "", string name = "");
    ~t_debugFile();
    void setDirName(string dir, string name);
    int newFile();
    int newSection(string title = "");
    int output(string aString);
    int appendFile(string filename);
};

bool cmpStats(struct stat stat1, struct stat stat2);

string str2Latex(string tmpStr);
QString getSizeText(const char* Beschr, unsigned long Groesse);
string holPfadInhalt(QListViewItem* itemPtr);
/*
bool vergleichPfade(KPath* Pfad1, KPath* Pfad2);
bool enthaeltPfad(KPath* Pfad1, KPath* Pfad2);
*/
void fehlermeldung(const char* inhalt);
void infomeldung(const char* inhalt);
bool ausschlussTrifft(string Pfad, vector<string> Muster);
string backslashifyWhitespace(string inputStr);
string backslashifySpecial(string inputStr);
void createPathItems(QListView*     ktl, 
		     string         pfad);
string dateiInhalt(string pfad);

string itoStr(long int nr, char fill, unsigned char digits);
string getNrPath(string root, string name);
string getNrFile(string root, string name);
bool existDat(string);
string whereisExec(string name);
int close_ofs(ofstream &outDat);
void dumpOptions(T_Options);
string holStartVerz(string);

int execKFM(string startDir);

int getPrefLang(string &lang1, string &lang2, string &lang3);

void writeKoverFileHeader(ofstream &);
void writeLatexFileHeader(ofstream &);
void writeKoverFileFooter(ofstream &);
void writeLatexFileFooter(ofstream &);

int writeCdrecordCmd(ofstream &outDat, T_Options aktOpts, T_FileOptions fileOpts);

string getDevID(string);
int createMirrDir(ofstream        &outDat, 
		  string          sessPfad, 
		  T_FileOptions   fileOpts, 
		  string          &linkFile,
		  string          HeimatPfad);
int deleteMirrDir(ofstream &outDat);

void downloadFile(string dropped);

string rmSlashes(string);
void mountViewImage(bool &fMounted, T_FileOptions fileOpts);
void unmountImage(bool &fMounted, string mountPoint);
string getPersConfigDir();
void getSysInfo(string pfad);

#endif  // __toolsXY__HEADERDAT


















