/***************************************************************************
                          createdirstruc.cpp  -  description
                             -------------------
    begin                : Sun Feb 13 2000
    copyright            : (C) 2000 by Kai Heitkamp
    email                : koncd@kai-heitkamp.de
 ***************************************************************************/
#include <qfiledialog.h>
#include <qdir.h>

#include <kmsgbox.h>
#include <kfiledialog.h>

#include "koncd.h"
#include "dirview.h"
#include "createdirstruc.h"

CreateDirStruc::CreateDirStruc(QWidget *parent, const char *name) : QDialog(parent,name,true) {
	setCaption( i18n( "KOnCD - File Manager" ) );
	initDialog();
	setupConnections();

	//Create tmp dir for iso-image
	QDir dir;
	if ( dir.exists() ) dir.mkdir( "/tmp/isoimage/", true );

	//Read directory tree and display them into the QListView_Source
	directory = new Directory( QListView_Source, "/" );
	directory->setAfficheFichiers( true );
	directory->setOpen( true );

	//Read directory tree and display them into the QListView_Target
	isotree = new ISOTree( QListView_Target, "/tmp/isoimage/" );
	isotree->setAfficheFichiers( true );
	isotree->setOpen( true );
}

CreateDirStruc::~CreateDirStruc(){
}

//Setup Connections
void CreateDirStruc::setupConnections(){
	connect( QPushButton_OK, SIGNAL(clicked()), SLOT(slotOK()) );
	connect( QPushButton_DeleteISOTree, SIGNAL(clicked()), SLOT(slotDeleteISOTree()) );
	connect( QPushButton_Add, SIGNAL(clicked()), SLOT(slotAdd()) );
	connect( QPushButton_CreateDir, SIGNAL(clicked()), SLOT(slotCreateDir()) );
	connect( QPushButton_Delete, SIGNAL(clicked()), SLOT(slotDelete()) );
}

//'Add'-Button clicked
void CreateDirStruc::slotAdd(){
	//If no item selected, return
	if ( !QListView_Source->currentItem() ) return;

	//---Symlink all selected files to tmp dir---

	QPushButton_Add->setEnabled( false );

	//Connect the 'processExited' Signal to the 'slotProcessExited' Slot
	connect( &process, SIGNAL(processExited(KProcess *)), this, SLOT(slotProcessExited(KProcess *)));

	//If no item selected, none text needed
	if ( !QListView_Target->currentItem() || QListView_Target->currentItem()->text(0) == "/" ) {
		//KProcess arguments
		process.clearArguments();
	 	process << "cp" << "-R" << "-s";
	 	process << getItemText( QListView_Source );
	 	process << "/tmp/isoimage/";
	}
	else {
		//KProcess arguments
		process.clearArguments();
	 	process << "cp" << "-R" << "-s";
	 	process << getItemText( QListView_Source );
	 	process << "/tmp/isoimage/" + getItemText( QListView_Target );
	}

	//Start KProcess
	if( ! process.start( KProcess::NotifyOnExit ) )
		{
		KMsgBox::message( this, i18n("KOnCD - Error"), i18n( "Couldn't start copy process !" ), 2 );			
		}
}

//KProcess finished
void CreateDirStruc::slotProcessExited(KProcess *rcproc) {

	//KProcess did exit normally
	if( rcproc->exitStatus() == 0 )
		{
		QPushButton_Add->setEnabled( true );
		QPushButton_CreateDir->setEnabled( true );
		QPushButton_Delete->setEnabled( true );
		QPushButton_DeleteISOTree->setEnabled( true );
		QPushButton_OK->setEnabled( true );
		}
	//KProcess didn't exit normally
	else
		{		
		KMsgBox::message( this, i18n("KOnCD - Error"), i18n( "An Error is occurred !" ), 2 );
		QPushButton_Add->setEnabled( true );
		QPushButton_CreateDir->setEnabled( true );
		QPushButton_Delete->setEnabled( true );
		QPushButton_DeleteISOTree->setEnabled( true );
		QPushButton_OK->setEnabled( true );
	   	}

	//If KProcess already running, kill it
	if( process.isRunning() ) process.kill();

	//Read directory tree and display them into the QListView_Target
	QListView_Target->clear();
	isotree = new ISOTree( QListView_Target, "/tmp/isoimage/" );
	isotree->setAfficheFichiers( true );
	isotree->setOpen( true );
}

//'OK'-Button clicked
void CreateDirStruc::slotOK(){
	close( true );
}

//'Delete ISO-Image-Tree'-Button clicked
void CreateDirStruc::slotDeleteISOTree(){
	//Connect the 'processExited' Signal to the 'slotProcessExited' Slot
	connect( &process, SIGNAL(processExited(KProcess *)), this, SLOT(slotProcessExited(KProcess *)));

	//KProcess arguments
	process.clearArguments();
 	process << "rm" << "-r" << "/tmp/isoimage/";

	//Start KProcess
	if( ! process.start( KProcess::NotifyOnExit ) )
		{
		KMsgBox::message( this, i18n("KOnCD - Error"), i18n( "Couldn't start delete process !" ), 2 );			
		}
}

//'CreateDir'-Button clicked
void CreateDirStruc::slotCreateDir(){
	//Create tmp dir for iso-image
	QDir dir;
	if ( dir.exists() ) dir.mkdir( "/tmp/isoimage/", true );

	QString getName;
	getName = KFileDialog::getSaveFileName( "/tmp/isoimage/" );
	dir.mkdir( getName );

	//Read directory tree and display them into the QListView_Target
	QListView_Target->clear();
	isotree = new ISOTree( QListView_Target, "/tmp/isoimage/" );
	isotree->setAfficheFichiers( true );
	isotree->setOpen( true );
}

//'Delete'-Button clicked
void CreateDirStruc::slotDelete(){
	//If no item selected, return
	if ( !QListView_Target->currentItem() ) return;

	//Connect the 'processExited' Signal to the 'slotProcessExited' Slot
	connect( &process, SIGNAL(processExited(KProcess *)), this, SLOT(slotProcessExited(KProcess *)));

	//KProcess arguments
	process.clearArguments();
 	process << "rm" << "-r";
	process << "/tmp/isoimage" + getItemText( QListView_Target );

	//Start KProcess
	if( ! process.start( KProcess::NotifyOnExit ) )
		{
		KMsgBox::message( this, i18n("KOnCD - Error"), i18n( "Couldn't start delete process !" ), 2 );			
		}
}

//Return the text from the selected item
QString CreateDirStruc::getItemText( QListView *pos ){
	//Read the text from the selected QListVieItem and their parents in reverse order to get the path
   QString SourceDir;
	QListViewItem * item = pos->currentItem();
	QListViewItem * parent = item->parent();
   	QString currentItemText = item->text(0);
	QString parentText = parent->text(0);

	if ( parentText == "/" ) {
	SourceDir = "/" + SourceDir + currentItemText;
	return SourceDir;
	}

	while ( parentText != "/" )
	{
		item = parent;
		parent = item->parent();
		parentText = item->text(0);

		if ( parentText != "/" ) SourceDir = parentText + "/" + SourceDir;
		if ( parentText == "/" ) SourceDir = "/" + SourceDir + currentItemText;
	}
	
	return SourceDir;

}