/***************************************************************************
                                dirview.h  -  description
                             -------------------
    begin                : Sun Feb 16 2000
    copyright            : (C) 2000 by Kai Heitkamp
    email                : koncd@kai-heitkamp.de
***************************************************************************/
/****************************************************************************
** $Id: main.cpp,v 1.7 1998/06/16 11:39:32 warwick Exp $
**
** Copyright (C) 1992-1998 Troll Tech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/

#include <qdir.h>
#include <qfile.h>
#include <qfileinfo.h>
#include "dirview.h"

Directory::Directory( Directory * parent, const char * filename, const char* image, bool voirfich )
    : QListViewItem( parent ), f(filename ), im(image)
{
	p = parent;
	fichiers=voirfich;
	setPixmap(0,im);
}


Directory::Directory( QListView * parent, char * path )
    : QListViewItem( parent ), f("/")
{
	p = 0;
	readable = true;
	fichiers = false;
	DirPath = path;
}

void Directory::setAfficheFichiers(bool fich)
{
	fichiers=fich;
}

void Directory::setOpen( bool o )
{
    if ( o && !childCount() ) {
	QString s( fullName() );
	QDir thisDir( s );

	if ( !thisDir.isReadable() ) {
	    readable = false;
	    return;
	}

	const QFileInfoList * files = thisDir.entryInfoList();
	if ( files ) {
		QString Filesize;
		QFileInfoListIterator it( *files );
		QFileInfo * f;
		QString dossier=kapp->kde_icondir()+"/mini/folder.xpm";
		QString dossierOuvert=kapp->kde_icondir()+"/mini/folder_open.xpm";
	    while( (f=it.current()) != 0 ) {
		Filesize.sprintf("%d",f->size());
		++it;
		if ( f->fileName() == "." || f->fileName() == ".." )
		    ; // nothing
		else if ( f->isSymLink() ) {
				new QListViewItem( this, (const char *)f->fileName(), "Symbolic Link", 0 );
		}
		else if (( f->isDir() ) && f->isReadable())
			{
				new Directory( this, f->fileName() ,(const char*)dossier, fichiers);
				setPixmap(0,QPixmap((const char*)dossierOuvert));
			}
		else if(fichiers)
		    new QListViewItem( this, (const char *)f->fileName(), f->isFile() ? "File" : "Special", Filesize );
		}
		}
	}
    QListViewItem::setOpen( o );
}


void Directory::setup()
{
    setExpandable( true );
    QListViewItem::setup();
}


QString Directory::fullName()
{
    QString s;
    if ( p ) {
	s = p->fullName();
	s.append( f.name() );
	s.append( "/" );
    } else {
	s = DirPath;
    }
    return s;
}


const char * Directory::text( int column ) const
{
    if ( column == 0 )
	return f.name();
   else if ( readable )
	return "Directory";
   else
	return "Directory";
}
