/***************************************************************************
                          copycd.cpp  -  description
                             -------------------
    begin                : Sun Mar 4 2001
    copyright            : (C) 2001 by Kai Heitkamp
    email                : koncd@kai-heitkamp.de
 ***************************************************************************/

#include <stdlib.h>

#include <qcombobox.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qprogressbar.h>
#include <qmultilineedit.h>
#include <qlabel.h>

#include <kapp.h>
#include <klocale.h>
#include <kconfig.h>
#include <kmessagebox.h>

#include "copycd.h"

CopyCD::CopyCD(QWidget *parent, const char *name ) : CopyCD_GUI(parent,name) {

	//Read config
	KConfig *config = kapp->config();
	config->setGroup( "Config - copycd" );

	QCheckBox_isosize->setChecked( config->readBoolEntry("QCheckBox_isosize") );
	QCheckBox_Simulate->setChecked( config->readBoolEntry("QCheckBox_Simulate") );
	QCheckBox_ignoresize->setChecked( config->readBoolEntry("QCheckBox_ignoresize") );
	QCheckBox_Eject->setChecked( config->readBoolEntry("QCheckBox_Eject") );
	QCheckBox_nofix->setChecked( config->readBoolEntry("QCheckBox_nofix") );
	QCheckBox_Force->setChecked( config->readBoolEntry("QCheckBox_Force") );
	QRadioButton_TaO->setChecked( config->readBoolEntry( "QRadioButton_TaO") );
	QRadioButton_DaO->setChecked( config->readBoolEntry( "QRadioButton_DaO") );

	QComboBox_CDRWOptions->setCurrentItem( config->readNumEntry("QComboBox_CDRWOptions") );
	QComboBox_WriterSpeed->setCurrentItem( config->readNumEntry("QComboBox_WriterSpeed") );

	//Connects for 'QRadioButton_DaO' toogle and 'QRadioButton_TaO' toggle
	connect( QRadioButton_DaO, SIGNAL(clicked()), SLOT(slot_toggleTaO()) );
	connect( QRadioButton_TaO, SIGNAL(clicked()), SLOT(slot_toggleDaO()) );

	//Check for RW-Device
	config->setGroup( "CD-Writer" );
	if ( config->readEntry( "isRW" ) == "false" ){
		QComboBox_CDRWOptions->clear();	
		QComboBox_CDRWOptions->insertItem(i18n( "None RW !" ));
		QComboBox_CDRWOptions->setEnabled( false );
	}
}

CopyCD::~CopyCD(){
}

//'QRadioButton_TaO' clicked , toggle 'QRadioButton_DaO'
void CopyCD::slot_toggleDaO(){
	if ( ! QRadioButton_DaO->isChecked() ){
		QRadioButton_TaO->setChecked( true );
	}
	else{
		QRadioButton_TaO->setChecked( true );
		QRadioButton_DaO->setChecked( false );
	}
}

//'QRadioButton_DaO' clicked , toggle 'QRadioButton_TaO'
void CopyCD::slot_toggleTaO(){
	if ( ! QRadioButton_TaO->isChecked() ){
		QRadioButton_DaO->setChecked( true );
	}
	else{
		QRadioButton_TaO->setChecked( false );
		QRadioButton_DaO->setChecked( true );
	}
}

// 'Start-Button' clicked
void CopyCD::slot_start(){

	//If TaO and DaO RadioButton false, return
	if ( ! QRadioButton_TaO->isChecked() && ! QRadioButton_DaO->isChecked() ){
		KMessageBox::error( 0, i18n("Audio CD:\nYou must select 'Track at Once' or 'Disc at Once' !") );
		return;
	}

	int rc;
	KProcess *process = new KProcess();

	//Connect the 'processExited' Signal to the 'slotProcessFinished' Slot to aktivate the Start- / Quit-Buttons
	connect( process, SIGNAL(processExited(KProcess *)), this, SLOT(slotProcessExited(KProcess *)));

	StatusLabel -> setText( i18n("Prepare for write...") );
	QPushButton_Start->setEnabled( false );
	QPushButton_Exit->setEnabled( false );

	process->clearArguments();
	(*process) << "cdrecord" << "-v";

	//Set the CD-Writer first
	KConfig *config = kapp->config();
	config->setGroup("CD-Writer");
	(*process) << config->readEntry("Device");

	//Set Burn-Proof
	if( config->readNumEntry("BurnProof") == true ) (*process) << "driveropts=burnproof";

	//Set CD-Writer Options to KProcess
	if( QCheckBox_Simulate->isChecked() ) (*process) << "-dummy";
	if( QCheckBox_ignoresize->isChecked() ) (*process) << "-ignsize";
	if( QCheckBox_isosize->isChecked() ) (*process) << "-isosize";
	if( QCheckBox_Eject->isChecked() ) (*process) << "-eject";
	if( QCheckBox_nofix->isChecked() ) (*process) << "-nofix";
	if( QCheckBox_Force->isChecked() ) (*process) << "-force";
	if( QRadioButton_DaO->isChecked() ) (*process) << "-dao";

	//Set CD-RW Options to KProcess
	if( (rc = QComboBox_CDRWOptions -> currentItem()) )
		{
	   	if( rc == 1 ) (*process) << "blank=all";
	   	if( rc == 2 ) (*process) << "blank=fast";
	   	if( rc == 3 ) (*process) << "blank=track";
	   	if( rc == 4 ) (*process) << "blank=unclose";
	   	}

	//Set CD-Writer Speed to KProcess
	if( (rc = QComboBox_WriterSpeed -> currentItem()) )
		{
	   	if( rc == 0 ) (*process) << "speed=1";
	   	if( rc == 1 ) (*process) << "speed=2";
	   	if( rc == 2 ) (*process) << "speed=4";
	   	if( rc == 3 ) (*process) << "speed=6";
	   	if( rc == 4 ) (*process) << "speed=8";
	   	if( rc == 5 ) (*process) << "speed=10";
	   	if( rc == 6 ) (*process) << "speed=12";
	   	if( rc == 7 ) (*process) << "speed=16";
	   	if( rc == 8 ) (*process) << "speed=20";
	   	}

	//Set the CD-Reader
	config->setGroup("CD-Reader");
	(*process) << config->readEntry("Device");


	//Connect with slotRecStderr to update KProgress (Write- / Buffer-Status) and StatusLine
	connect( process, SIGNAL(receivedStdout (KProcess *, char *, int) ), this, SLOT(slotRecStderr (KProcess *, char *, int) ));
	connect( process, SIGNAL(receivedStderr (KProcess *, char *, int) ), this, SLOT(slotRecStderr (KProcess *, char *, int) ));

	//Start KProcess
	if( ! process->start( KProcess::NotifyOnExit, KProcess::AllOutput ) )
		{
		KMessageBox::error( 0, i18n("Copy CD:\nCould not start cdrecord !") );
		return;
		}
}

//KProcess outout analysis
void CopyCD::slotRecStderr( KProcess *, char *buffer, int buflen) {
	char *c, buf[1024];
	int wrote, total, load;

	if( !buflen ) {
		return;
	}

	bzero( buf, sizeof( buf ) );
	strncpy( buf, buffer, buflen > (int) sizeof( buf ) ? sizeof(buf) - 1 : buflen );

	//Add cdrecord Messages to the Output-Window
	Output->insertLine( buf );
	//Go to the End of the Output-Text
	Output->setCursorPosition(Output->numLines(),0,false);

	//Blanking a CD-RW
	if( strstr( buf, "Blanking" )) {
		StatusLabel -> setText( i18n("Blanking the CDRW...") );
	}

	//Burn without Fixating
	if( strstr( buf, "Writing  time:" )) {
		StatusLabel -> setText( i18n("Burn-Process complete.") );
	}

	//Fixating the CD-R
	if( strstr( buf, "Fixating..." )) {
		StatusLabel -> setText( i18n("Writing TOC...") );
	}

	//Burn with Fixating
	if( strstr( buf, "Fixating time:" )) {
		StatusLabel -> setText( i18n("Burn-Process complete.") );
   	}
	
	if( strstr( buf, "MB written" )) {
		c = index( buf, ':' );
		if( c && *c ) {
			c = strtok( c, ":\r\t " );
			if( c ) {
				wrote = atoi( c );
				c = strtok( NULL, "\r\t " );
				c = strtok( NULL, "\r\t " );
				if( c ) {
					total = atoi( c );
					c = strtok( NULL, "\r" );
					c = strstr( c, "fifo " );
					if( c ) {
						c = strtok( c + 5, "%\r\t " );
						if( c ) {
							load = atoi( c );
							WriteProgress -> setProgress( total ? wrote * 100 / total : 0 );
							BufferProgress -> setProgress( load );

							if( wrote ) {
								if( QCheckBox_Simulate->isChecked() ) {
									StatusLabel -> setText( i18n("Writing to CD in dummy mode...") );
								}
								else {
									StatusLabel -> setText( i18n("Writing to CD...") );
								}
							}
				
							if( ( total == wrote ) && ( QCheckBox_Simulate->isChecked() == false )) {
								StatusLabel -> setText( i18n("Writing TOC...") );
							}

						}
					}
				}
			}
		}		
	}	
}

//KProcess finished
void CopyCD::slotProcessExited(KProcess *rcproc) {
   int noperms = 13;		//Exitcode for no enough permissions
   int nocd = 123;		//Exitcode for no CD in the Reader-Device
	int nocdr = 255;		//Exitcode for no CD-R in the Writer-Device
	int corruptcd = 254;	//Exitcode for corrupt CD in Writer-Device

	//KProcess did not exit normally
	if( ! rcproc -> normalExit() )
		{
		QPushButton_Start->setEnabled( true );
		QPushButton_Exit->setEnabled( true );
		KMessageBox::sorry( 0, i18n("Copy CD:\nThe process was aborted !") );
		return;
		}

	//KProcess did exit normally, it does have a valid exit status
	if( rcproc -> exitStatus() )
		{
		QString statusout;
		statusout.sprintf( "\nError, exit status: %d\n", rcproc->exitStatus() );
		Output->insertLine( statusout );
		Output->setCursorPosition(Output->numLines(),0,false);
		StatusLabel -> setText( i18n( "An Error is occurred !" ) );
		if( rcproc->exitStatus() == nocd ) StatusLabel -> setText( i18n( "Error: No CD in the Reader-Device !" ) );
		if( rcproc->exitStatus() == nocdr ) StatusLabel -> setText( i18n( "Error: No CD-R(W) in the Writer-Device !" ) );
		if( rcproc->exitStatus() == corruptcd ) StatusLabel -> setText( i18n( "Error: Corrupt CD in the Writer-Device !" ) );
		if( rcproc->exitStatus() == noperms ) StatusLabel -> setText( i18n( "Error: You don't have enough permissions !" ) );
		QPushButton_Start->setEnabled( true );
		QPushButton_Exit->setEnabled( true );
		}
	//KProcess did exit normally, normalExit() = true
	else
		{		
		QPushButton_Start->setEnabled( true );
		QPushButton_Exit->setEnabled( true );
   	}
}

// 'Exit-Button' clicked
void CopyCD::slot_quit(){

	//Write config
	KConfig *config = kapp->config();
	config->setGroup( "Config - copycd" );
	config->writeEntry( "QCheckBox_Simulate", QCheckBox_Simulate->isChecked() );
	config->writeEntry( "QCheckBox_isosize", QCheckBox_isosize->isChecked() );
	config->writeEntry( "QCheckBox_ignoresize", QCheckBox_ignoresize->isChecked() );
	config->writeEntry( "QCheckBox_Eject", QCheckBox_Eject->isChecked() );
	config->writeEntry( "QCheckBox_nofix", QCheckBox_nofix->isChecked() );
	config->writeEntry( "QCheckBox_Force", QCheckBox_Force->isChecked() );
	config->writeEntry( "QRadioButton_TaO", QRadioButton_TaO->isChecked() );
	config->writeEntry( "QRadioButton_DaO", QRadioButton_DaO->isChecked() );

	config->writeEntry( "QComboBox_CDRWOptions", QComboBox_CDRWOptions->currentItem() );
	config->writeEntry( "QComboBox_WriterSpeed", QComboBox_WriterSpeed->currentItem() );

	close( true );
}
