// KreateCD - CD recording software for the K desktop environment
//
// 1998 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#ifndef DRIVEACCESS_INCLUDED
#define DRIVEACCESS_INCLUDED

#include <qwidget.h>
#include <kprocess.h>

#define MAX_SCSI_UNITS    8
#define MAX_SCSI_HOSTS    8

class CDTrack;
class Fork;

class DriveAccess : public QObject
 {
  Q_OBJECT;
  public:
    enum  Fixating {Fix_None,Fix_Session,Fix_CD};

    int         getSCSIType(int unit,int host);
    const char *getSCSIManu(int unit,int host);
    const char *getSCSIProd(int unit,int host);
    void scanSCSIBus(void);
    int  readTOC(void);
    int  paranoiaTrack(int track,char *filename);
    int  readDataTrack(int track,char *filename,long int lba_start,long int size_hint);



    long int    getTOCDuration(int track);
    long int    getTOCLBA(int track);
         int    getTOCType(int track);         /* 0 = Audio  4= Data Mode*/
         int    getTOCMode(int track);          
    long int    getTOCSum(void);



         int    burnCD(int ntrack,CDTrack **track,int simmode,int speed,Fixating fix,int eject);
    long int    getCDFree(int ntrack=0,CDTrack **track=0,Fixating fix=Fix_CD);


  protected slots:

    void        getScanBus(KProcess *proc,char *buffer,int bufflen);
    void        getTOC(KProcess *proc,char *buffer,int bufflen);
    void        getParanoia(KProcess *proc,char *buffer,int bufflen);
    void        leaveParanoia(KProcess *proc);
    void        getISO(KProcess *proc,char *buffer,int bufflen);
    void        leaveISO(KProcess *proc);
    void        getCdrecord(KProcess *proc,char *buffer,int bufflen);
    void        leaveCdrecord(KProcess *proc);

  protected:
         int    callRecord(int ntrack,CDTrack **track,int simmode,int speed,Fixating fix,int eject,bool capread=false);


  private:
    int current_scsibus;
    int  scsitype[MAX_SCSI_HOSTS][MAX_SCSI_UNITS];
    char scsimanuf[MAX_SCSI_HOSTS][MAX_SCSI_UNITS][40];
    char scsiprod[MAX_SCSI_HOSTS][MAX_SCSI_UNITS][40];

    long int toc_lba[128];
    long int toc_durat[128];
    int toc_adr[128];
    int toc_control[128];
    int toc_mode[128];
    long int tocsum;

    class KProcess *cdrproc;
    class ProgressDialog *paranoiaprogress;
    class ProgressDialog *isoprogress;
    class ProgressDialog *cdrecordprogress;

    int paranoiafrom,paranoiato;

    class Fork           *IsoFork;

    int ripflag;
    int burnstate,burntrack,burnsize,burnoffset;

    bool     getCapacity;
    long int blocksTotal;
    long int blocksFree;
    long int blocksRemain;


    char linebuffer[512];

 };

#endif


