// KreateCD - CD recording software for the K desktop environment
//
// 1999 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     


#include "MainWindow.h"
#include "CDTrack.h"
#include "ConfPath.h"
#include "DriveAccess.h"


#include <kapp.h>
#include <klocale.h>
#include <kmsgbox.h>

#include <unistd.h>


KLocale *locale;

int callUID,callGID;

int dropRootRights(void)
 {
  long int nomod=-1;
  if (setreuid(nomod,callUID)) return(0);
  if (setregid(nomod,callGID)) return(0);
  return(1);
 }

int getRootRights(void)
 {
  long int nomod=-1;
  if (setreuid(nomod,0)) return(0);
  if (setregid(nomod,0)) return(0);
  return(1);
 }

int main(int argc,char **argv)
 {
  int e1,e2,e3;
  callUID=getuid();
  callGID=getgid();
  e1=dropRootRights();
  e2=getRootRights();
  e3=dropRootRights();

  KApplication KreateCDApp(argc,argv,"kreatecd");
  locale=new KLocale();
  if (locale==0) return(0);
  

#if QT_VERSION >= 200
  if ( (!e1) || (!e2) ||(!e3) )
   {
    KMsgBox::message(0,QString::null,locale->translate("Must run as root or set-UID root!"),KMsgBox::STOP);
    return(0);
   }
  
  if (!ConfPath::verifyPrograms())
   {
    KMsgBox::message(0,QString::null,locale->translate("Warning : some programs needed by KreateCD\nwere not found!\n\n"
                                           "Please visit the path configuration!"),KMsgBox::EXCLAMATION);
   }
#else
  if ( (!e1) || (!e2) ||(!e3) )
   {
    KMsgBox::message(0,0,locale->translate("Must run as root or set-UID root!"),KMsgBox::STOP);
    return(0);
   }

  if (!ConfPath::verifyPrograms())
   {
    KMsgBox::message(0,0,locale->translate("Warning : some programs needed by KreateCD\nwere not found!\n\n"
                                           "Please visit the path configuration!"),KMsgBox::EXCLAMATION);
   }
#endif
  MainWindow MainWin;
    
  KreateCDApp.enableSessionManagement(FALSE);
  KreateCDApp.setMainWidget(&MainWin);
  KreateCDApp.setTopWidget(&MainWin);

  MainWin.show(); 
  return(KreateCDApp.exec());
 }
