// KreateCD - CD recording software for the K desktop environment
//
// 1999 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#include "ConfSCSI.h"

#include <kapp.h>
#include <klocale.h>
#include <kconfig.h>

#include <qlabel.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qpushbutton.h>
#include <qwindowdefs.h>
#include <qlayout.h>
#include <qspinbox.h>

#include <strings.h>
#include <stdio.h>

extern KLocale *locale;

ConfSCSI::ConfSCSI( QWidget *parent, const char *name):QWidget(parent,name)
 {
  int i,k,dev=0;
  KConfig *config;
  QRect DefaultRect(100,50,500,300);
  QVBoxLayout  *mainlayout;
  QGridLayout  *cdrlayouthl;
  QVBoxLayout  *cdrlayoutop;
  QVBoxLayout  *cdrlayout;
  QGridLayout  *cdromlayouthl;
  QVBoxLayout  *cdromlayoutop;
  QVBoxLayout  *cdromlayout;
  QHBoxLayout  *buttonlayout;

 

  config=kapp->getConfig();


  config->setGroup("SCSI");
  writer_id=config->readNumEntry("SCSIWriterUnit",-1);
  cdrom_id=config->readNumEntry("SCSICdromUnit",-1);
  writer_host=config->readNumEntry("SCSIWriterHost",0);
  cdrom_host=config->readNumEntry("SCSICdromHost",0);



  setCaption(locale->translate("KreateCD - SCSI configuration"));

  mainlayout=new QVBoxLayout(this);

  SCSIBus=new DriveAccess();
  SCSIBus->scanSCSIBus();

  scsiboxes[0]=new QButtonGroup(locale->translate("CD writer"),this,"writer group");
  scsiboxes[0]->setAlignment(AlignHCenter);
  scsiboxes[0]->setMinimumSize(300,60);
  cdrlayouthl=new QGridLayout(scsiboxes[0],3,4,20,0);
  cdrlayouthl->setColStretch(0,0);
  cdrlayouthl->setColStretch(1,0);
  cdrlayouthl->setColStretch(2,0);
  cdrlayouthl->setColStretch(3,1);
  cdrlayouthl->addColSpacing(0,15);
  cdrlayouthl->addColSpacing(2,15);
  cdrlayoutop=new QVBoxLayout();
  cdrlayouthl->addLayout(cdrlayoutop,1,1);
  cdrlayout=new QVBoxLayout();
  cdrlayouthl->addLayout(cdrlayout,1,3);

  scsiboxes[1]=new QButtonGroup(locale->translate("CD-ROM"),this,"cdrom group");
  scsiboxes[1]->setAlignment(AlignHCenter);
  scsiboxes[1]->setMinimumSize(300,60);
  cdromlayouthl=new QGridLayout(scsiboxes[1],3,4,20,0);
  cdromlayouthl->setColStretch(0,0);
  cdromlayouthl->setColStretch(1,0);
  cdromlayouthl->setColStretch(2,0);
  cdromlayouthl->setColStretch(3,1);
  cdromlayouthl->addColSpacing(0,15);
  cdromlayouthl->addColSpacing(2,15);
  cdromlayoutop=new QVBoxLayout();
  cdromlayouthl->addLayout(cdromlayoutop,1,1);
  cdromlayout=new QVBoxLayout();
  cdromlayouthl->addLayout(cdromlayout,1,3);

  for (k=0;k<MAX_SCSI_HOSTS;++k)
   {
    for (i=0;i<MAX_SCSI_UNITS;++i)
     {
      scsidevs[k][i][0]=0;
      if (SCSIBus->getSCSIType(i,k)==2)
       {
        sprintf(scsidevs[k][i],"/dev/scd%d",dev);
        ++dev;
       }
     }
   }

  for (i=0;i<MAX_SCSI_UNITS;++i)
   {
    scsibuttons[0][i]=new QRadioButton(scsiboxes[0]);
    cdrlayout->addWidget(scsibuttons[0][i]);
   }

  for (i=0;i<MAX_SCSI_UNITS;++i)
   {
    scsibuttons[1][i]=new QRadioButton(scsiboxes[1]);
    cdromlayout->addWidget(scsibuttons[1][i]);
   }

   {
    QLabel *lab;
    writerhostspin=new QSpinBox(scsiboxes[0]);
    writerhostspin->setRange(0,MAX_SCSI_HOSTS-1);
    writerhostspin->setFixedSize(writerhostspin->sizeHint());
    cdrlayoutop->addStretch(1);
    lab=new QLabel(locale->translate("SCSI host"),scsiboxes[0],0,0);
    lab->setFixedSize(lab->sizeHint());
    cdrlayoutop->addWidget(lab);
    cdrlayoutop->addWidget(writerhostspin);
    cdrlayoutop->addStretch(1);
   }

   {
    QLabel *lab;
    cdromhostspin=new QSpinBox(scsiboxes[1]);
    cdromhostspin->setRange(0,MAX_SCSI_HOSTS-1);
    cdromhostspin->setFixedSize(cdromhostspin->sizeHint());
    cdromlayoutop->addStretch(1);
    lab=new QLabel(locale->translate("SCSI host"),scsiboxes[1],0,0);
    lab->setFixedSize(lab->sizeHint());
    cdromlayoutop->addWidget(lab);
    cdromlayoutop->addWidget(cdromhostspin);
    cdromlayoutop->addStretch(1);
   }

  connect(scsiboxes[0],SIGNAL(clicked(int)),this,SLOT(clickedWriter(int)));
  connect(scsiboxes[1],SIGNAL(clicked(int)),this,SLOT(clickedCDROM(int)));

  updateWriterButtons();
  updateCdromButtons();
  writerhostspin->setValue(writer_host);
  scsiboxes[0]->setButton(writer_id);
  cdromhostspin->setValue(cdrom_host);
  scsiboxes[1]->setButton(cdrom_id);

  mainlayout->addWidget(scsiboxes[0]);
  mainlayout->addStretch(1);
  mainlayout->addWidget(scsiboxes[1]);


  buttonlayout=new QHBoxLayout();
  mainlayout->addStretch(1);
  mainlayout->addSpacing(5);
  mainlayout->addLayout(buttonlayout);
  mainlayout->addSpacing(5);
  mainlayout->addStretch(1);

  okbutton=new QPushButton(locale->translate("OK"),this);
  okbutton->setFixedSize(okbutton->sizeHint());
  buttonlayout->addStretch();
  buttonlayout->addWidget(okbutton);
  buttonlayout->addStretch();
  applybutton=new QPushButton(locale->translate("Apply"),this);
  applybutton->setFixedSize(applybutton->sizeHint());
  buttonlayout->addWidget(applybutton);
  buttonlayout->addStretch();
  cancelbutton=new QPushButton(locale->translate("Cancel"),this);
  cancelbutton->setFixedSize(cancelbutton->sizeHint());
  buttonlayout->addWidget(cancelbutton);
  buttonlayout->addStretch();


  connect(okbutton,SIGNAL(clicked()),this,SLOT(okButton()));
  connect(applybutton,SIGNAL(clicked()),this,SLOT(applySettings()));
  connect(cancelbutton,SIGNAL(clicked()),this,SLOT(cancelButton()));
  connect(writerhostspin,SIGNAL(valueChanged(int)),
          this,SLOT(changedWriterHost(int)));
  connect(cdromhostspin,SIGNAL(valueChanged(int)),
          this,SLOT(changedCdromHost(int)));


  cdrlayouthl->activate();
  cdromlayouthl->activate();
  mainlayout->activate();

  config->setGroup("Geometry");
  this->setGeometry(config->readRectEntry("SCSIWindowGeo",&DefaultRect));

 }


ConfSCSI::~ConfSCSI(void)
 {
  KConfig *config;
  QRect SaveRect(this->pos(),this->size());
  config=kapp->getConfig();
  config->setGroup("Geometry");
  config->writeEntry("SCSIWindowGeo",SaveRect);
  delete (SCSIBus);
 }

void ConfSCSI::applySettings(void)
 {
  KConfig *config;
  config=kapp->getConfig();
  config->setGroup("SCSI");
  config->writeEntry("SCSIWriterHost",writer_host);
  config->writeEntry("SCSIWriterUnit",writer_id);
  if (writer_id!=1)
   {
#if QT_VERSION >= 200
    config->writeEntry("SCSIWriterDevice",QString(scsidevs[writer_host][writer_id]));
#else
    config->writeEntry("SCSIWriterDevice",scsidevs[writer_host][writer_id]);
#endif
   }
   else
   {
    config->writeEntry("SCSIWriterDevice","");
   }
  config->writeEntry("SCSICdromHost",cdrom_host);
  config->writeEntry("SCSICdromUnit",cdrom_id);
  if (cdrom_id!=-1)
   {
#if QT_VERSION >= 200
    config->writeEntry("SCSICdromDevice",QString(scsidevs[cdrom_host][cdrom_id]));
#else
    config->writeEntry("SCSICdromDevice",scsidevs[cdrom_host][cdrom_id]);
#endif
   }
   else
   {
    config->writeEntry("SCSICdromDevice","");
   }
 }

void ConfSCSI::updateWriterButtons(void)
 {
  int i;
  char tempscsi[80];
  for (i=0;i<MAX_SCSI_UNITS;++i)
   {
    if (SCSIBus->getSCSIType(i,writer_host)==0)
     {
      sprintf(tempscsi,locale->translate("ID : %d - No drive connected"),i);
     }
     else
     {
#if QT_VERSION >= 200
      sprintf(tempscsi,locale->translate("ID : %d - %s %s (%s)"),
               i,SCSIBus->getSCSIManu(i,writer_host),SCSIBus->getSCSIProd(i,writer_host),
               SCSIBus->getSCSIType(i,writer_host)==2?
               locale->translate("CD-ROM").ascii():locale->translate("Hard drive").ascii());
#else
      sprintf(tempscsi,locale->translate("ID : %d - %s %s (%s)"),
               i,SCSIBus->getSCSIManu(i,writer_host),SCSIBus->getSCSIProd(i,writer_host),
               SCSIBus->getSCSIType(i,writer_host)==2?
               locale->translate("CD-ROM"):locale->translate("Hard drive"));
#endif
     }
    scsibuttons[0][i]->setText(tempscsi);
    scsibuttons[0][i]->setMinimumSize(scsibuttons[0][i]->sizeHint());
    scsibuttons[0][i]->setEnabled((SCSIBus->getSCSIType(i,writer_host)==2)?TRUE:FALSE);
  }
 }

void ConfSCSI::updateCdromButtons(void)
 {
  int i;
  char tempscsi[80];
  for (i=0;i<MAX_SCSI_UNITS;++i)
   {
    if (SCSIBus->getSCSIType(i,cdrom_host)==0)
     {
      sprintf(tempscsi,locale->translate("ID : %d - No drive connected"),i);
     }
      else
     {
#if QT_VERSION >= 200
      sprintf(tempscsi,locale->translate("ID : %d - %s %s (%s)"),
               i,SCSIBus->getSCSIManu(i,cdrom_host),SCSIBus->getSCSIProd(i,cdrom_host),
               SCSIBus->getSCSIType(i,cdrom_host)==2?
               locale->translate("CD-ROM").ascii():locale->translate("Hard drive").ascii());
#else
      sprintf(tempscsi,locale->translate("ID : %d - %s %s (%s)"),
               i,SCSIBus->getSCSIManu(i,cdrom_host),SCSIBus->getSCSIProd(i,cdrom_host),
               SCSIBus->getSCSIType(i,cdrom_host)==2?
               locale->translate("CD-ROM"):locale->translate("Hard drive"));
#endif
     }
    scsibuttons[1][i]->setText(tempscsi);
    scsibuttons[1][i]->setMinimumSize(scsibuttons[1][i]->sizeHint());
    scsibuttons[1][i]->setEnabled((SCSIBus->getSCSIType(i,cdrom_host)==2)?TRUE:FALSE);
   }

 }

void ConfSCSI::hide()
 {
  QWidget::hide();
  emit closed();
 }

void ConfSCSI::okButton(void)
 {
  applySettings();
  hide();
 }

void ConfSCSI::cancelButton(void)
 {
  hide();
 }
void ConfSCSI::clickedWriter(int unit)
 {
  writer_id=unit;  
 }

void ConfSCSI::clickedCDROM(int unit)
 {
  cdrom_id=unit;
 }

void ConfSCSI::changedWriterHost(int host)
 {
  if ( (host>=(MAX_SCSI_HOSTS-1)) || (host<0) ) return;
  writer_host=host;
  updateWriterButtons();
  writer_id=-1;
  scsiboxes[0]->setButton(writer_id);
 }

void ConfSCSI::changedCdromHost(int host)
 {
  if ( (host<0) || (host>=(MAX_SCSI_HOSTS-1)) ) return;
  cdrom_host=host;
  updateCdromButtons();
  cdrom_id=-1;
  scsiboxes[1]->setButton(cdrom_id);
 }

