// KreateCD - CD recording software for the K desktop environment
//
// 1999 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.


class ISOFile;
class QString;
class KProcess;

#include <qobject.h>

class ISOImage : public QObject
 {
  Q_OBJECT
  public:
    enum ISOType {CustomType=0,Unix=1,UnixWin=2,Win=3,MSDos=4};
    ISOImage(void);
    ISOImage(class KConfig *config);
    ~ISOImage(void);

    ISOFile *imageRoot(void);
    void setImageRoot(ISOFile *root);

    bool buildImageTree(void);
    bool clearImageTree(void);

    void loadConfig(class KConfig *config);
    void saveConfig(class KConfig *config);
    void saveImage(class KConfig *config);

    void    setOptionsDefault(ISOType type);
    ISOType getOptionsDefault(void);

    bool getOmitTrailingDot(void);
    bool getNoDeepRelocation(void);
    bool getLongISONames(void);
    bool getAllowLeadingDot(void);
    bool getOmitVersions(void);
    bool getWithRockRidge(void);
    bool getWithAnonymousRockRidge(void);
    bool getMakeTransTab(void);
    bool getWithJoliet(void);
    bool getAllFiles(void);

    const char *getApplicationID(void);
    const char *getPreparerID(void);
    const char *getPublisherID(void);
    const char *getVolumeID(void);
    const char *getSystemID(void);

    bool makeImage(const char *fname);

  signals:
    void imageChanged(void);

  public slots:

    void setOmitTrailingDot(bool b);
    void setNoDeepRelocation(bool b);
    void setLongISONames(bool b);
    void setAllowLeadingDot(bool b);
    void setOmitVersions(bool b);
    void setWithRockRidge(bool b);
    void setWithAnonymousRockRidge(bool b);
    void setMakeTransTab(bool b);
    void setWithJoliet(bool b);
    void setAllFiles(bool b);

    // QT 1.x slots
    void setApplicationID(const char *id);
    void setPreparerID(const char *);
    void setPublisherID(const char *);
    void setVolumeID(const char *);
    void setSystemID(const char *);

    // QT 2.x slots
    void setApplicationID(const QString &id);
    void setPreparerID(const QString &id);
    void setPublisherID(const QString &id);
    void setVolumeID(const QString &id);
    void setSystemID(const QString &id);

  protected slots:
    void leaveIsofs(KProcess *process);
    void getIsofs(KProcess *process,char *buffer,int bufflen);



  private:
    void             initConfigPutter(class KConfig *);
    void             putConfigObject(const char *s1, const QString *s2=0,const QString *s3=0);
    void             putISOFile(class ISOFile *);

    int              cputIndex;
    class KConfig   *cputConfig;

    ISOFile         *rootObject;
    QString         *fileTree;

    char             applicationID[130];
    char             preparerID[130];
    char             publisherID[130];
    char             volumeID[34];
    char             systemID[34];


    bool             omitTrailingDot;
    bool             noDeepRelocation;
    bool             longISONames;
    bool             allowLeadingDot;
    bool             omitVersions;
    bool             withRockRidge;
    bool             withAnonymousRockRidge;
    bool             makeTransTab;
    bool             withJoliet;
    bool             allFiles;

    class ProgressDialog *isoprogress;

    char             linebuffer[256];

    int              isoflag;
 };

