// KreateCD - CD recording software for the K desktop environment
//
// 1999 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include <qwidget.h>

class TrackWindow : public QWidget
 {
  Q_OBJECT;
  public:
         TrackWindow( QWidget *parent=0, const char *name=0,class CDTrack *track=0);
         ~TrackWindow(void);
         void hide(void);
  signals:
         void closed(void);
         void updateTrack(void);

  public slots:
         void updateWindowContents(void);

  protected slots:
         void changeTrackMode(int modeindex);
         void changeSourceType(int sourceindex);
         void changeSource(void);
         void changeUseImage(bool useimage);
         void changeDescription(const char *descr);    // QT 1.x slot
         void changeDescription(const QString &descr); // QT 2.x slot
         void openOptions(void);
         void closedAudioOptions(void);
         void closedISOTree(void);
         void closedISOOptions(void);
         void makeImageDirty(void);

  private:
         void updateWindow();

         class CDTrack         *ThisTrack;
         class QLabel          *LabTrackType;
         class QComboBox       *CombTrackType;
         class QLabel          *LabSourceType;
         class QComboBox       *CombSourceType;
         class QCheckBox       *CheckUseImage;
         class QPushButton     *ButtonSelectSource;
         class QGroupBox       *PropertyFrame;
         class QPushButton     *ButtonOptions;
         class QLabel          *DescriptionLabel;
#if QT_VERSION >= 200
         class KLineEdit       *DescriptionEdit;
#else
         class KLined          *DescriptionEdit;
#endif
         class QLabel          *PropertyLabel;
         class QPushButton     *OkButton;

         class AudioOptions    *AudioOptWindow;
         class ISOWindow       *ISOTreeWindow;
         class ISOOptions      *ISOOptWindow;

         int                    ignsigs;

 };

