// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifndef APPCHOOSER_INCLUDED
#define APPCHOOSER_INCLUDED

/**
    @short AppChooser - choosing under different equivalent helper applications
    @author Alexander Feigl <Alexander.Feigl@gmx.de>

    The AppChooser class servers as a selection class which chooses under different
    helper application classes which are quivalent. (e.g TOCScanning with cdrecord
    or with cdda2wav). It provides pointers to the virtual base classes for these helper
    applications

*/

class AudioRipper;
class DataRipper;
class TOCReader;


class AppChooser
 {
   public:
     static AudioRipper *getAudioRipper(void);
     static DataRipper *getDataRipper(void);
     static TOCReader *getTOCReader(void);
     static TOCReader *readTOC(void);
 };


#endif
