// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#include "AudioFile.h"

#include <stdlib.h>
#include <stdio.h>
#include <strings.h>
#include <unistd.h>
#include <fcntl.h>

#include <sys/stat.h>
#include <sys/ioctl.h>

#include <qtimer.h>
#include <qobject.h>
#include <klocale.h>


extern KLocale *locale;

int AudioFile::needImage(void)
 {
  if (SampleChannels!=2) return(1);
  if (SampleRate!=44100) return(1);
  if (DataPos!=0) return(1);
  if (SampleEndian!=Endian_Big) return(1);
  if ( (SelectedStart!=0) || (SelectedEnd!=(DataSamples-1))) return(1);
  if ( (BoostFactor!=1) || (Balance!=0) ) return(1);
  return(0);
 }

enum AudioFile::Sample_Size AudioFile::getSampleSize(void)
 {
  return(SampleSize);
 }

long int AudioFile::getSampleRate(void)
 {
  return(SampleRate);
 }

enum AudioFile::Sample_Endian AudioFile::getEndian(void)
 {
  return(SampleEndian);
 }

int AudioFile::getChannels(void)
 {
  return(SampleChannels);
 }
int AudioFile::getAbsoluteDuration(void)
 {
  long long xdur;
  xdur=((long long) DataSamples)*75;
  return(xdur/SampleRate);
 }

int AudioFile::getSelectedDuration(void)
 {
  long long xdur;
  xdur=(((long long )SelectedEnd)-((long long )SelectedStart)+1)*75;
  return(xdur/SampleRate);
 } 

void AudioFile::getFormat(char *formatstring)
 {
  strcpy(formatstring,Format);
 }


void AudioFile::setBoost(float boost)
 {
  BoostFactor=boost;
 }

float AudioFile::getBoost(void)
 {
  return(BoostFactor);
 }

float AudioFile::getBalance(void)
 {
  return(Balance);
 }

void AudioFile::setBalance(float balance)
 {
  Balance=balance;
 }

void AudioFile::setStartPos(long int pos)
 {
  if (pos>(DataSamples-1)) pos=DataSamples-1;
  if (pos<0) pos=0;
  SelectedStart=pos;
  if (SelectedEnd<SelectedStart) SelectedEnd=DataSamples-1;
 }

void AudioFile::setEndPos(long int pos)
 {
  if (pos>(DataSamples-1)) pos=DataSamples-1;
  if (pos<0) pos=0;
  SelectedEnd=pos;
  if (SelectedEnd<SelectedStart) SelectedStart=0;
 }


long int AudioFile::getStartPos(void)
 {
  return(SelectedStart);
 }

long int AudioFile::getEndPos(void)
 {
  return(SelectedEnd);
 }



