// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include "AudioFileFormat.h"
#include "AudioFile.h"

#include <stdlib.h>
#include <stdio.h>
#include <strings.h>
#include <unistd.h>
#include <fcntl.h>

#include <sys/stat.h>
#include <sys/ioctl.h>

#include <qtimer.h>
#include <qobject.h>
#include <klocale.h>

extern KLocale *locale;

AudioFileFormat::AudioFileFormat(AudioFile *afil):AudioFileOp(afil)
 {

 }

int AudioFileFormat::setupCDTrack(const char *filename)
 {
  struct stat mstat;
  if (!openRead(filename)) return(0);
  if (fstat(AudioFD,&mstat)!=0)
   {
    closeRead();
    return(0);
   } 
  closeRead();
  strcpy(myAudio->FileName,filename);
  myAudio->SampleChannels=2;
  myAudio->SampleSize=AudioFile::Samples_16Bit;
  myAudio->SampleRate=44100;
  myAudio->DataSize=mstat.st_size;
  myAudio->DataPos=0;
  myAudio->SampleEndian=AudioFile::Endian_Big;
  strcpy(myAudio->Format,"CD");

  myAudio->SampleBytes=myAudio->SampleChannels;
  myAudio->SampleBytes*=2;
  myAudio->DataSamples=myAudio->DataSize/myAudio->SampleBytes;
  myAudio->SelectedStart=0;
  myAudio->SelectedEnd=myAudio->DataSamples-1;
  myAudio->BoostFactor=1;
  myAudio->Balance=0;
  myAudio->MaxBoost=-1;

  return(1);
 }

int AudioFileFormat::identifyFile(const char *filename)
 {
  if (!openRead(filename)) return(0);

  if (identifyMSWave()) goto posID;
  closeRead();
  return(0);
  posID:
  closeRead();
  strcpy(myAudio->FileName,filename);
  myAudio->SampleBytes=myAudio->SampleChannels;
  if (myAudio->SampleSize==myAudio->Samples_16Bit) myAudio->SampleBytes*=2;
  if (myAudio->SampleSize==myAudio->Samples_32Bit) myAudio->SampleBytes*=4;
  myAudio->DataSamples=myAudio->DataSize/myAudio->SampleBytes;
  myAudio->SelectedStart=0;
  myAudio->SelectedEnd=myAudio->DataSamples-1;
  myAudio->BoostFactor=1;
  myAudio->Balance=0;
  myAudio->MaxBoost=-1;
  return(1);
 }

// Microsoft Wave file : parse header

int AudioFileFormat::identifyMSWave(void)
 {
  char string[6];
  long int filesize,chunksize;
  int hasformat=0,hasdata=0;
  long int wavformat,wavchannels,wavalign,wavsamsize;
  long int wavaverage,wavrate;
  long int datapos=0,datasize=0;

  lseek(AudioFD,0,SEEK_SET);
  if (!readString(string,4)) return(0);
  string[5]=0;
  if (strncmp(string,"RIFF",4)!=0) return(0);
  if (!readLELong(&filesize)) return(0);
  if (!readString(string,4)) return(0);
  if (strncmp(string,"WAVE",4)!=0) return(0);
  filesize-=4;
  while (1)
   {
    if ( (hasformat) && (hasdata) ) break;
    if (filesize==0) break;
    if (filesize<8)
     {
      return(0);
     }
    if (!readString(string,4)) return(0);
    if (!readLELong(&chunksize)) return(0);
    filesize-=8;
    if (filesize<chunksize)
     {
      return(0);
     }
    filesize-=chunksize;
    if (strncmp(string,"fmt ",4)==0)
     {
      if (chunksize<16) return(0);
      hasformat=1;
      if (!readLEShort(&wavformat)) return(0);
      if (!readLEShort(&wavchannels)) return(0);
      if (!readLELong(&wavrate)) return(0);
      if (!readLELong(&wavaverage)) return(0);
      if (!readLEShort(&wavalign)) return(0);
      if (!readLEShort(&wavsamsize)) return(0);
      if (chunksize>16)
       {
        if (!skipRead(chunksize-16)) return(0);
       }
     }
     else
     {
      if (strncmp(string,"data",4)==0)
       {
        datapos=lseek(AudioFD,0,SEEK_CUR);
        datasize=chunksize;
        hasdata=1;
        if (!skipRead(chunksize)) return(0);
       }
       else
       {
        if (!skipRead(chunksize)) return(0);

       }
     }
   }
  if ( (!hasformat) || (!hasdata)) return(0);
  switch (wavformat)
   {
    case 1: //WAVE_FORMAT_PCM
      myAudio->SampleFormat=AudioFile::Samples_PCM;
      break;

    case 0: //WAVE_FORMAT_UNKNOWN
    case 0x2: //WAVE_FORMAT_ADPCM
    case 0x6: //WAVE_FORMAT ALAW
    case 0x7: //WAVE_FORMAT_MULAW
    case 0x10: //WAVE_FORMAT_OKI_ADPCM
    case 0x15: //WAVE_FORMAT_DIGISTD
    case 0x16: //WAVE_FORMAT_DIGIFIX
    case 0x101: //IBM_FORMAT_MULAW
    case 0x102: //IBM_FORMAT_ALAW
    default:
      return(0);

   }
  switch (wavsamsize)
   {
    case 8:
       myAudio-> SampleSize=AudioFile::Samples_8Bit;
      break;
    case 16:
        myAudio->SampleSize=AudioFile::Samples_16Bit;
      break;
    case 32:
        myAudio->SampleSize=AudioFile::Samples_32Bit;
      break;
    default:
      return(0);
   }
  myAudio->SampleEndian=AudioFile::Endian_Little;
  myAudio->SampleChannels=wavchannels;
  myAudio->SampleRate=wavrate;
  myAudio->DataPos=datapos;
  myAudio->DataSize=datasize;
  if ( (myAudio->SampleChannels<=0 ) || (myAudio->SampleRate<=0) || (myAudio->DataSize==0))
   {
    return(0);
   }
  strcpy(myAudio->Format,"MS Windows WAV");
  return(1);
 }


