// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifndef AUDIOSCANIMAGE_INCLUDED
#define AUDIOSCANIMAGE_INCLUDED

#include "AudioFileOp.h"
#include <qobject.h>

class AudioScanImage : public AudioFileOp
 {
   Q_OBJECT

   public:
    AudioScanImage(AudioFile *afil);
    float    maximumBoost(const char *fn);
    int                  scanImage(void);
    void setMaxBoost(void);

   private:
    static int scanImageHFork(AudioFileOp *afi,const char *fn);

   protected:
    virtual int processExited(void);
    virtual bool processStdoutLine(char *buf);

 };


#endif

