// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include "CDParanoia.h"
#include "uidcontrol.h"
#include "pathconfig.h"

#include <qstring.h>
#include <kconfig.h>
#include <kprocess.h>
#include <kapp.h>

#include <stdlib.h>
#include <stdio.h>

bool CDParanoia::doRip(int track,const char *filename)
 {
  KConfig *config;

  char devline[32],trackline[32];
  QString cddev;

#if QT_VERSION >= 200
  config=kapp->config();
#else
  config=kapp->getConfig();
#endif
  config->setGroup("SCSI");
  cddev=config->readEntry("SCSICdromDevice","");
  if (cddev[0]==0) return(false);

  sprintf(devline,"-d%s",cddev.data());
  sprintf(trackline,"%d",track);
  config->setGroup("Path");
  if ROOT_CALLED
   {
    *this<<config->readEntry("PathCdparanoia",PATH_CDPARANOIA)<<"-R"<<"-e"<<devline<<trackline<<filename;
   }
   else
   {
    *this<<PATH_CDPARANOIA<<"-R"<<"-e"<<devline<<trackline<<filename;
   }
  paranoiafrom=0;
  paranoiato=999999;
  return(true);
 }

bool CDParanoia::processStderrLine(char *linebuffer)
 {
  if (strncmp("Ripping from sector",linebuffer,19)==0)
   {
    char *xptr;
    long int val;
    xptr=linebuffer+19;
    if (*xptr=='\0') return(true);
    while ( *xptr==' ') ++xptr;
    val=strtol(xptr,0,10);
    paranoiafrom=val;
   }
  if (strncmp("\t  to sector",linebuffer,12)==0)
   {
    char *xptr;
    long int val;
    xptr=linebuffer+12;
    if (*xptr=='\0') return(true);
    while ( *xptr==' ') ++xptr;
    val=strtol(xptr,0,10);
    paranoiato=val;
    startTrack((long) paranoiato-paranoiafrom+1);
   }
  if (strncmp("##: ",linebuffer,4)==0)
   {
    char *xptr;
    long int val,pval;
    xptr=linebuffer+4;
    if (*xptr=='\0') return(true);
    while ( *xptr==' ') ++xptr;
    val=strtol(xptr,0,10);
    if (val!=-2) return(true);
    while ( (*xptr!='@') && (*xptr!='\0') ) ++xptr;
    if (*xptr=='\0') return(true);
    ++xptr;
    while ( *xptr==' ') ++xptr;
    pval=strtol(xptr,0,10);
    pval/=1176;
    if ( (pval>=paranoiafrom) && (pval<=paranoiato) )
     {
      setPosition(pval-paranoiafrom);
     }
   }
  if (strncmp("Done.",linebuffer,5)==0) ripflag=1;
  return(true);
 }
