// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.


#include "DataRipper.h"
#include "uidcontrol.h"

#include <kapp.h>
#include <klocale.h>

#include <qmessagebox.h>

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

extern KLocale *locale;

DataRipper::DataRipper(void):ProcessInterface()
 {

 }

DataRipper::DataRipper(int (*fx)(int argc,char **argv)):ProcessInterface(fx)
 {

 }

bool DataRipper::readDataTrack(int track,char *filename,long int lba_start,long int size_hint)
 {
  int retval;

  char progressline[64];

  ripDataTrack(filename,lba_start,size_hint);
  sprintf(progressline,locale->translate("Extracting data track %d from CD..."),track);
  setWorkText(progressline);

  ripflag=-2;

  retval=startProcess();  // 1=ripping was OK  -1=abort 0=winclose
                               // -2=unexpected process term -3= DevError
                               // -4=Memory -5=Read -6=Write
#ifndef STRICT_PERMISSIONS
  getRootRights();
  chown(filename,getuid(),getgid());
  dropRootRights();
#endif
  if (retval!=1) remove(filename);
  switch (retval)
   {
#if QT_VERSION >= 200
    case -2:
      QMessageBox::critical(0,QString::null,locale->translate("Reading process died!"));
      break;
    case -3:
      QMessageBox::critical(0,QString::null,locale->translate("Cannot access the drive! (no disc?)"));
      break;
    case -4:
      QMessageBox::critical(0,QString::null,locale->translate("Cannot get buffer memory!"));
      break;
    case -5:
      QMessageBox::critical(0,QString::null,locale->translate("CDROM read error occured!"));
      break;
    case -6:
      QMessageBox::critical(0,QString::null,locale->translate("Image file write error! (harddisk full?)"));
      break;
#else
    case -2:
      QMessageBox::critical(0,0,locale->translate("Reading process died!"));
      break;
    case -3:
      QMessageBox::critical(0,0,locale->translate("Cannot access the drive! (no disc?)"));
      break;
    case -4:
      QMessageBox::critical(0,0,locale->translate("Cannot get buffer memory!"));
      break;
    case -5:
      QMessageBox::critical(0,0,locale->translate("CDROM read error occured!"));
      break;
    case -6:
      QMessageBox::critical(0,0,locale->translate("Image file write error! (harddisk full?)"));
      break;
#endif
   }

 closeProcess();

  if (retval!=1) return(false);

  return(true);
 }

int DataRipper::processExited(void)
 {
  return(ripflag);
 }

bool DataRipper::ripDataTrack(char *,long int ,long int)
 {
  return(false);
 }

