// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#ifndef PROGRESSDIALOG_INCLUDED
#define PROGRESSDIALOG_INCLUDED

#include <qwidget.h>
#include <qlistview.h>

class ProgressDialog : public QWidget
 {
  Q_OBJECT;

  public:

    enum ProgressType {Progress_None,Progress_Single,Progress_Double};


    ProgressDialog( QWidget *parent=0, const char *name=0, const char *workingtext=0,enum ProgressType ptyp=Progress_Single,bool modal=true);
    ~ProgressDialog(void);
    void addStatusView(void);
    void printStatusLine(QString line);
    int  exec(void);

  public slots:
    void setWorkText(const char *newworktext=0);
    void abortDialog(int returncode=-1);
    void abortCancel(void);
    void setProgress(long int val,long int maxval);
    void setSecondProgress(long int val,long int maxval);
    void setProtectedProgress(long int val,long int maxval); // don't decrease values
    void setSecondProtectedProgress(long int val,long int maxval);
    void done(int result);

  protected slots:
    void cancelPressed(void);

  signals:
    void canceled(void);

  private:
     class KProgress *pwidget;
     class KProgress *pwidget2;
     class QPushButton *pcancel;
     class QVBoxLayout *pvlayout;
     class QLabel *pwork;
     class KEdit *edit;

     long int oldval,oldmax;
     long int oldval2,oldmax2;
     char progresstext[2048];
     char worktext[1024];

     int  progressResult;
     bool wasShown;
     bool isModal;
 };

#endif
