// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include "TopWidget.h"

#include <kapp.h>
#include <klocale.h>
#include <kmenubar.h>
#include <kconfig.h>

#include <qkeycode.h>

#include "MainWindow.h"

extern KLocale *locale;


TopWidget::TopWidget(const char *name):KTMainWindow(name) {
  QRect DefaultRect(100,20,500,430);
  KConfig *config;
  MainWindow *mainw;


#if QT_VERSION >= 200
  config=kapp->config();
#else
  config=kapp->getConfig();
#endif



  mainw=new MainWindow(this);
  setView(mainw);

  MWMenu=new KMenuBar(this,"kreatecd menu");
  QPopupMenu *filemenu=new QPopupMenu;
  filemenu->insertItem(locale->translate("New project..."),mainw,SLOT(newProject()));
  filemenu->insertItem(locale->translate("Open project..."),mainw,SLOT(openProject()));
  filemenu->insertSeparator();
  filemenu->insertItem(locale->translate("Save project"),mainw,SLOT(saveProject()));
  filemenu->insertItem(locale->translate("Save project as..."),mainw,SLOT(saveProjectAs()));
  filemenu->insertSeparator();
  filemenu->insertItem(locale->translate("Quit"),kapp,SLOT(quit()));
  MWMenu->insertItem(locale->translate("File"),filemenu);
  QPopupMenu *toolsmenu=new QPopupMenu;
  toolsmenu->insertItem(locale->translate("&Copy CDROM..."),mainw,SLOT(setupCopy()));
  QPopupMenu *audiomenu=new QPopupMenu;
  audiomenu->insertItem(locale->translate("Normalize to maximum"),mainw,SLOT(normalizeMax()));
  audiomenu->insertItem(locale->translate("Normalize all to same"),mainw,SLOT(normalizeAllSame()));
  toolsmenu->insertItem(locale->translate("Audio"),audiomenu);
  QPopupMenu *blankmenu=new QPopupMenu;
  blankmenu->insertItem(locale->translate("blank entire disk"),mainw,SLOT(blankAll()));
  blankmenu->insertItem(locale->translate("fast blanking"),mainw,SLOT(blankFast()));
  blankmenu->insertItem(locale->translate("blank track"),mainw,SLOT(blankTrack()));
  blankmenu->insertItem(locale->translate("unreserve track"),mainw,SLOT(blankUnreserve()));
  blankmenu->insertItem(locale->translate("blank track tail"),mainw,SLOT(blankTail()));
  blankmenu->insertItem(locale->translate("unclose last session"),mainw,SLOT(blankUnclose()));
  blankmenu->insertItem(locale->translate("blank last session"),mainw,SLOT(blankSession()));
  toolsmenu->insertItem(locale->translate("CD-RW blanking"),blankmenu);

  MWMenu->insertItem(locale->translate("&Tools"),toolsmenu);
  QPopupMenu *configmenu=new QPopupMenu;
  configmenu->insertItem(locale->translate("SCSI..."),mainw,SLOT(configSCSI()));
  configmenu->insertItem(locale->translate("Paths..."),mainw,SLOT(configPath()));
  configmenu->insertItem(locale->translate("ISO 9660..."),mainw,SLOT(configISO()));
  MWMenu->insertItem(locale->translate("Configure"),configmenu);
  MWMenu->insertSeparator();
  QPopupMenu *helpmenu=new QPopupMenu;
  helpmenu->insertItem(locale->translate("Contents"),mainw,SLOT(helpContents()),Key_F1,-1);
  helpmenu->insertSeparator();
  helpmenu->insertItem(locale->translate("About KreateCD..."),mainw,SLOT(helpAboutMe()));
  MWMenu->insertItem(locale->translate("Help"),helpmenu);

  setMenu(MWMenu);

  config->setGroup("Geometry");
  this->setGeometry(config->readRectEntry("MainWindowGeo",&DefaultRect));
}


TopWidget::~TopWidget()
 {
  KConfig *config;
  QRect SaveRect(this->pos(),this->size());

#if QT_VERSION >= 200
  config=kapp->config();
#else
  config=kapp->getConfig();
#endif
  config->setGroup("Geometry");
  config->writeEntry("MainWindowGeo",SaveRect);
 }
