// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#include <qwidget.h>
#include <qdialog.h>
#include <qlistview.h>

#include "CDWriter.h"

class CDTrack;

class WriteDialog : public QDialog
 {
  Q_OBJECT;
  public:
    WriteDialog( QWidget *parent=0, const char *name=0,int ntrack=0,CDTrack **tracks=0);
 
  protected slots:
    void writeCD(void);
    void exitDialog(void);
    void changeSpeed(int id);
    void changeFixating(int id);
    void changeSimulation(bool sim);
    void changeEject(bool eject);



  private:


    CDTrack **cdtracks;
    int      numtracks;

    int                   Burnspeed;
    CDWriter::Fixating XFixating;
    int                   Simmode;
    int                   XEject;


 };


