#ifndef _IFFACTORY_H_
#define _IFFACTORY_H_

#include "ifMain.h"
#include "ifTrack.h"
#include "ifPart.h"
#include "ifPrefs.h"
#include "ifEditor.h"

class KbMain;
class KbTrack;
class KbPart;

/**
 * This abstract class serves as an interface for a factory.
 * @short Factory Interface
 * @author Jan Wuerthner
 * @version 0.95
 * @see QtFactory
 */
class IfFactory
{
 public:
  IfFactory();
  virtual IfMain * createMain(KbMain*,int,char**);
  virtual IfTrack * createScoreTrack(KbTrack*);
  virtual IfTrack * createMasterTrack(KbTrack*);
  virtual IfTrack * createDrumTrack(KbTrack*);
  virtual IfTrack * createWaveTrack(KbTrack*);
  virtual IfTrack * createCommentTrack(KbTrack*);
  virtual IfPart * createPart(KbPart*);
  virtual IfPrefs * createPrefs();
  virtual IfEditor * createScoreEditor();
  virtual IfEditor * createPianoEditor();
  virtual IfEditor * createDrumEditor();
};

#endif
