#ifndef _KBEXP_C_
#define _KBEXP_C_

#include "kbExp.h"
#include "kbNote.h"

KbExp::KbExp(KbNote * n, int e) : KbNoteExt(n), exp(e), yoff(0) {}

KbExp::KbExp(KbNote * n, int e, int o) : KbNoteExt(n), exp(e), yoff(o) {}

int KbExp::gExpression() { return exp; }

int KbExp::gOffset() { return yoff; }

void KbExp::sExpression(int e) { exp = e; }

void KbExp::sOffset(int o) { yoff = o; }

/*KbNoteExt * KbExp::gNext() {
  KbNoteExt * e = next;
  for (;(e != 0) && (e->isExp()==false); e = e->next) {}
  return e;
  }*/

bool KbExp::isLyrics() { return false; }

bool KbExp::isStem() { return false; }

bool KbExp::isExp() { return true; }

bool KbExp::isBow() { return false; }


ostream & KbExp::print(ostream&s) {
  s << "<EXP expression=\"" << exp << "\" offset=\"" << yoff << "\" />" << endl;
}

KbNoteExt * KbExp::copy() {
  return new KbExp(note,exp,yoff);
}

#endif
