#ifndef _KBNOTE_H_
#define _KBNOTE_H_

#include "kbAtom.h"

class KbNoteExt;
class KbNote;
class KbLyrics;
class KbStem;
class KbExp;
class KbBow;

/**
 * Objects of this class are notes. They do not need a (graphical) presentation of their own. They can be displayed
 * graphically within the presentation of the parts, they belong to. This is done in editors.
 * @short Note Class
 * @author Jan Wuerthner
 * @version 0.97
 */
class KbNote : public KbAtom
{
 private:
  int freq;
  int vel;
  int len;
  KbPosition pos;
  int enh;
  int chan;
  KbNoteExt * ext;
  
 public:
  KbNote( );
  KbNote(int f,int v ,int l,KbPosition p,int e,int c=-1);

  int gFreq();
  int gVel();
  int gLen();
  KbPosition gPos();
  int gEnh();
  int gChan();
  KbNoteExt * gExt();
  void sFreq(int f);
  void sVel(int v);
  void sLen(int l);
  void sPos(KbPosition p);
  void sEnh(int e);
  void sChan(int c);
  void sExt(KbNoteExt*);
  void appendExt(KbNoteExt*);
  KbExp * giveExp(int);
  KbBow * giveBow(int,int,int);
  KbLyrics * lyrics();
  int stemDir(); // stemDir = -1: undefined, 0: down, 1: up
  int expression();
  int bowLength();
  KbExp * gExp(KbNoteExt*start=0);
  KbBow * gBow();
  void flipStem();
  void flipBow();
  void removeExp();
  void removeBow();
  virtual bool isNote();
  virtual bool isAuxElement();
  virtual bool isMidiEvent();
  virtual bool isMasterEvent();
  virtual ostream & print(ostream&);
  virtual KbAtom * copy();
};


#endif
