#ifndef _KBSTEM_H_
#define _KBSTEM_H_

#include "kbNoteExt.h"
class KbNote;

enum { StemUp, StemDown };

/**
 * Objects of this class are stems. They do not need a (graphical) presentation of their own. They can be displayed
 * graphically within the presentation of the parts, they belong to. This is done in editors.
 * @short Stem Class
 * @author Jan Wuerthner
 * @version 0.97
 */
class KbStem : public KbNoteExt
{
 private:
  int dir;

 public:
  KbStem(KbNote*,int);
  void flip();
  int gDir();
  bool Up();
  bool Down();
  void sDir(int);
  void sUp();
  void sDown();
  // virtual KbNoteExt * gNext();
  virtual bool isLyrics();
  virtual bool isStem();
  virtual bool isExp();
  virtual bool isBow();
  virtual ostream & print(ostream&);
  virtual KbNoteExt * copy();
};


#endif
