#include <linux/mc146818rtc.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <stdio.h>
#include "rtcclock.h"

RtcClock::RtcClock()
{
	int retval;
	rtc_fd = open ("/dev/rtc", O_RDONLY);
 
	if (rtc_fd == -1) {
   		perror("/dev/rtc");
		exit(errno);
	}

	rate = 8192;
	if(ioctl(rtc_fd, RTC_IRQP_SET, 8192) == -1)
    {
		printf("Well - got no root rights, so the realtime clock rate is\n");
		printf("64 Hz now, which may sound ugly sometimes\n");
		rate = 64;

		retval = ioctl(rtc_fd, RTC_IRQP_SET, rate);
		if (retval == -1) {
			perror("ioctl while setting frequency");
			exit(errno);
		}
	}

	retval = ioctl(rtc_fd, RTC_PIE_ON, 0);
	if (retval == -1) {
		perror("ioctl");
		exit(errno);
	}

	elapsed = 0;
}

void RtcClock::WaitUntil(float seconds)
{
	float time = 0;

	while((time = Time()) < seconds) PollTick();
	printf("time %f, seconds %f\n",time,seconds);
}

void RtcClock::PollTick()
{
	long data;
	int retval = read(rtc_fd, &data, sizeof(unsigned long));
	if (retval == -1) {
		perror("read");
		exit(errno);
	}
	elapsed += data/256;
}

void RtcClock::Reset()
{
	PollTick();
	elapsed = 0;
}

float RtcClock::Time()
{
	return (float)elapsed/(float)rate;
}

RtcClock::~RtcClock()
{
	int retval = ioctl(rtc_fd, RTC_PIE_OFF, 0);
	if (retval == -1) {
		perror("ioctl");
		exit(errno);
	}

	close(rtc_fd);
}
