#ifndef _QTEVENT_C_
#define _QTEVENT_C_

#include "qtEvent.h"
#include "kbNote.h"
#include "kbPart.h"
#include "kbTrack.h"
#include "kbAtom.h"

// ******************************************************************
//
// Constructor
// ===========
//


QtEvent::QtEvent(KbPart * kbpart)
  : part(kbpart), top(0)
{
  // QtEditor::init();
  // setBackgroundMode( PaletteLight );
  setMinimumWidth(640);
  // Contents:
  // =========

  splitter = new QSplitter(this);
  splitter->setResizeMode(splitter,QSplitter::Stretch);
  splitter->setOpaqueResize(TRUE);
  
  lw = new LeftWidget( this,part,splitter );
  lw->setBackgroundMode( PaletteLight );
  lw->show();
  ew = new EventWidget( this,part,splitter );
  ew->setFrameStyle( QFrame::Panel | QFrame::Raised );
  // ew->setLineWidth(2);
  ew->setBackgroundMode( PaletteMidlight );
  ew->show();
  // setView( splitter );
  splitter->setGeometry(12,12,width()-24, height()-112);
  splitter->show();

  QPushButton * exit = new QPushButton(" OK ",this);
  exit->setGeometry(width()-60,height()-96,48,48);
  exit->show();
  connect(exit,SIGNAL(released()),SLOT(exit()));

  show();
}

void QtEvent::exit() { delete this; }

int QtEvent::getTop() { return top; }

void QtEvent::setTop(int i) { top = i; }

void QtEvent::updateEW() { ew->repaint(); }

int QtEvent::itemHeight() { return itemh; }

void QtEvent::setItemHeight(int i) { itemh = i; }


EventWidget::EventWidget( QtEvent * qte, KbPart * pt, QWidget * parent ) : QFrame(parent), qtevent(qte), part(pt) {}


LeftWidget::LeftWidget( QtEvent * qte, KbPart * pt, QWidget * parent ) : QListBox(parent), qtevent(qte), part(pt) {
  qtevent->setItemHeight(itemHeight());
  getEntries();
}

void LeftWidget::getEntries() {
  char * txt;
  KbPosition pos;
  int bars; int beats; int ticks;
  KbPart * master = part->gTrack()->gMain()->Master();
  int met0 = part->gTrack()->gMain()->gMeter(0);
  int met1 = part->gTrack()->gMain()->gMeter(1);
  for (KbAtom * atom = part->gFirstAtom(); atom!=0; atom = atom->gNext()) {
    txt = new char[96];
    pos = atom->gPos();
    pos.gBBT(bars,beats,ticks,master,met0,met1);
    sprintf(txt,"%d . %d . %d\0",bars,beats,ticks);
    insertItem(txt);
    delete[] txt;
  }
}


void LeftWidget::paintEvent( QPaintEvent * pe ) {
  QListBox::paintEvent(pe);
  qtevent->setTop(topItem());
  qtevent->updateEW();
}


void EventWidget::paintEvent( QPaintEvent * pe ) {
  QPainter p;
  p.begin(this);

  int barlen = (int) width()*0.25;
  int barnum = 4;
  int yScale = qtevent->itemHeight();
  int offset = qtevent->getTop();
  int pos;
  int line = 0;
  int len = 0;
  unsigned long xoff = 0;
  for (KbAtom * atom = part->gFirstAtom(); atom!=0; atom = atom->gNext()) {
    if (offset>0) offset--;
    else {
      if (offset==0) { offset = -1; xoff = atom->gPos().gPosTicks(); } 
      pos = (int) (atom->gPos().gPosTicks() - xoff);
      pos = (pos*barlen)/1536;
      len = 2;
      if (atom->isNote()) {
	len = ((KbNote*)atom)->gLen(); len = (len*barlen)/1536;
      }
      p.fillRect(pos,1+(yScale*line)+2,len,yScale-2,black);
      line++;
    }
  }

  p.end();
}

#endif
