#ifndef _QTFACTORY_C_
#define _QTFACTORY_C_

#include "qtFactory.h"
#include "qtMain.h"
#include "qtTrack.h"
#include "qtScoreTrack.h"
#include "qtMasterTrack.h"
#include "qtDrumTrack.h"
#include "qtWaveTrack.h"
#include "qtCommentTrack.h"
#include "qtPart.h"
#include "qtPrefs.h"
#include "qtScore.h"
#include "qtPiano.h"
#include "qtDrum.h"

#include "kbMain.h"

#include <iostream.h>

QtFactory::QtFactory() {}

IfMain * QtFactory::createMain(KbMain * kbmain, int argc, char ** argv) {
  KApplication* kooBase = new KApplication( argc, argv, "Brahms");
  QtMain * widget = new QtMain( "Brahms", kooBase, kbmain, argc, argv );
  kooBase->setMainWidget( widget );
  return widget;
}

IfTrack * QtFactory::createScoreTrack(KbTrack * kbtrack) {
   QtTrack * qtr = new QtScoreTrack(kbtrack);
   qtr->show();
   return qtr;
}

IfTrack * QtFactory::createMasterTrack(KbTrack * kbtrack) {
   QtTrack * qtr = new QtMasterTrack(kbtrack);
   qtr->show();
   return qtr;
}

IfTrack * QtFactory::createDrumTrack(KbTrack * kbtrack) {
   QtTrack * qtr = new QtDrumTrack(kbtrack);
   qtr->show();
   return qtr;
}

IfTrack * QtFactory::createWaveTrack(KbTrack * kbtrack) {
   QtTrack * qtr = new QtWaveTrack(kbtrack);
   qtr->show();
   return qtr;
}

IfTrack * QtFactory::createCommentTrack(KbTrack * kbtrack) {
   QtTrack * qtr = new QtCommentTrack(kbtrack);
   qtr->show();
   return qtr;
}


IfPart * QtFactory::createPart(KbPart * kbpart) {
  QtPart * qpt = new QtPart(kbpart);
  qpt->show();
  return qpt;
}

IfPrefs * QtFactory::createPrefs() {
  return new QtPrefs(0,"");
}

IfEditor * QtFactory::createScoreEditor(KbPart * kbpart) {
  return new QtScore(kbpart);
}

IfEditor * QtFactory::createPianoEditor(KbPart * kbpart) {
  return new QtPiano(kbpart);
}

IfEditor * QtFactory::createDrumEditor(KbPart * kbpart) {
  return new QtDrum(kbpart);
}


#endif
