#ifndef _QTFACTORY_H_
#define _QTFACTORY_H_

#include "ifFactory.h"

class KbMain;
class KbTrack;

/**
 * This Qt Class serves as a concrete implementation of a factory. Its methods create all possible aspects
 * of the Brahms Qt GUI
 * @short Qt Factory
 * @author Jan Wuerthner
 * @version 0.95
 */
class QtFactory : public IfFactory
{
 public:
  
  /// Constructor.
  QtFactory();
  
  /// Creates the qt presentation of the main object.
  virtual IfMain *   createMain(KbMain*,int,char**);

  /// Creates the qt presentation of a track.
  virtual IfTrack *  createScoreTrack(KbTrack*);

  /// Creates the qt presentation of a track.
  virtual IfTrack *  createMasterTrack(KbTrack*);

  /// Creates the qt presentation of a track.
  virtual IfTrack *  createDrumTrack(KbTrack*);

  /// Creates the qt presentation of a track.
  virtual IfTrack *  createWaveTrack(KbTrack*);

  /// Creates the qt presentation of a track.
  virtual IfTrack *  createCommentTrack(KbTrack*);

  /// Creates the qt presentation of a part
  virtual IfPart *   createPart(KbPart*);

  /// Creates the qt presentation of the preferences
  virtual IfPrefs *  createPrefs();

  /// Creates the qt presentation of the Score Editor
  virtual IfEditor * createScoreEditor(KbPart*);

  /// Creates the qt presentation of the PianoRoll Editor
  virtual IfEditor * createPianoEditor(KbPart*);

  /// Creates the qt presentation of the Drum Editor
  virtual IfEditor * createDrumEditor(KbPart*);
};

#endif
