#ifndef _QTMASTERTRACK_C_
#define _QTMASTERTRACK_C_

#include "kbTrack.h"
#include "qtMasterTrack.h"
#include <iostream.h>


QtMasterTrack::QtMasterTrack(KbTrack * kbtrack)
  : QtTrack(kbtrack)
{
  /*
  int n = track->trackNum()+1; // the underlying kbTrack of this qtTrack is not registered yet, that's why +1 !
  int hh = height();
  setGeometry(0,n*(1+hh),width(),hh);
  */
  
  KIconLoader * loader = kapp->getIconLoader();
  
  QPixmap * pmMute = new QPixmap(loader->loadIcon( "mute.xpm" ));

  int hh = height();
  mute = new TogBut( 0, track, pmMute, 0, this, "mute" );
  mute->setFrameStyle( QFrame::Panel | QFrame::Raised );
  mute->setGeometry(0,0,24,hh+1);

  type->chooseMaster();

}

void QtMasterTrack::erase() {
  delete this;
}

void QtMasterTrack::update() {
  QtTrack::update();
  mute->update(); track->gMain()->muteTrack(track->trackNum());
  show();
}




#endif
