#ifndef _QTPART_C_
#define _QTPART_C_

#include "qtPart.h"
#include "qtPartCanvas.h"
#include "qtTrack.h"
#include "qtScore.h"
#include "qtDrum.h"
#include "qtPiano.h"
#include "qtEvent.h"
#include "qtTEEdit.h"
#include "qtCEdit.h"
#include "qtWEdit.h"
#include "kbPart.h"
#include "kbTrack.h"
#include "kbMain.h"
#include "kbNote.h"
#include "kbMasterEvent.h"

#include "partFunctions/kbPartExtension.h"

#include <iostream.h>

extern const char * gmNames[];
extern const char * gmCat[];

QtPart::QtPart(KbPart * kbpart)
  : qtmain((QtMain*)kbpart->gTrack()->gMain()->gInterface()),
    pcanvas(((QtMain*)kbpart->gTrack()->gMain()->gInterface())->gPartCanvas()),
    QLabel((QLabel*)((QtMain*)kbpart->gTrack()->gMain()->gInterface())->gPartCanvas(),"part"),
    part(kbpart)
{
  int n = kbpart->gTrack()->trackNum()+1;
  setGeometry(pcanvas->gOffset(),n*(qtmain->gTrackHeight()+1),2,qtmain->gTrackHeight());
  setFrameStyle( QFrame::Panel | QFrame::Raised );
  instPM = new QPopupMenu(  );
  for (int i=0;i<16;i++) {
    instPMs[i] = new QPopupMenu(  );
    instPMs[i]->setCheckable(TRUE);
    for (int k=0;k<8;k++)
      instPMs[i]->insertItem(gmNames[i*8+k],i*8+k);
    connect(instPMs[i],SIGNAL(activated(int)),SLOT(instMenu(int)));
    instPM->insertItem(gmCat[i], instPMs[i]);
  }

  userDef = new QPopupMenu();
  KbExtensionManager * em = qtmain->gMain()->extManager();
  for(em->init();em->getExtension()!=0;em->incr()) {
    userDef->insertItem(klocale->translate(em->getExtension()->name()));
  }

  connect(userDef,SIGNAL(activated(int)),SLOT(userDefMenu(int)));

  int typ = kbpart->gTrack()->isA();

  rbmenu = new QPopupMenu;
  rbmenu->setMouseTracking( TRUE );
  if (typ==0) rbmenu->connectItem( rbmenu->insertItem(klocale->translate("Edit Score")), this, SLOT(scoreEdit()) );
  if (typ==1) rbmenu->connectItem( rbmenu->insertItem(klocale->translate("Edit Drummap")), this, SLOT(drumEdit()) );
  if (typ==0) rbmenu->connectItem( rbmenu->insertItem(klocale->translate("Edit Piano Roll")), this, SLOT(pianoRollEdit()) );
  if (typ<2) rbmenu->connectItem( rbmenu->insertItem(klocale->translate("Edit Events")), this, SLOT(eventEdit()) );
  // rbmenu->connectItem( rbmenu->insertItem(klocale->translate("Adjust Part Size")), this, SLOT(adjustPartSize()) );
  if (typ<2) rbmenu->insertSeparator();
  if (typ==2) {
    rbmenu->connectItem( rbmenu->insertItem(klocale->translate("Edit Time Events")), this, SLOT(eventTimeEdit()) );
    rbmenu->insertSeparator();
  }
  if (typ==3) {
    rbmenu->connectItem( rbmenu->insertItem(klocale->translate("Edit Wave Events")), this, SLOT(waveEdit()) );
    rbmenu->insertSeparator();
  }
  if (typ==4) {
    rbmenu->connectItem( rbmenu->insertItem(klocale->translate("Edit comment")), this, SLOT(commentEdit()) );
    rbmenu->insertSeparator();
  }
  if (typ<4) {
    rbmenu->connectItem( rbmenu->insertItem(klocale->translate("Copy Part")), this, SLOT(partCopy()) );
    rbmenu->connectItem( rbmenu->insertItem(klocale->translate("Glue Parts")), this, SLOT(partGlue()) );
    rbmenu->connectItem( rbmenu->insertItem(klocale->translate("Split Part")), this, SLOT(partSplit()) );
    rbmenu->insertSeparator();
  }
  if (typ==0) {
    rbmenu->insertItem(klocale->translate("Instrument"), instPM );
    rbmenu->insertSeparator();
  }
  if (typ<2) {
  rbmenu->insertItem(klocale->translate("User Defined Functions"), userDef );
  rbmenu->insertSeparator();
  }
  if (typ<3) {
    rbmenu->connectItem( rbmenu->insertItem(klocale->translate("Quantize All")), this, SLOT(partq()) );
    rbmenu->connectItem( rbmenu->insertItem(klocale->translate("Quantize Lengths")), this, SLOT(partql()) );
    rbmenu->connectItem( rbmenu->insertItem(klocale->translate("Fixed Length")), this, SLOT(partfl()) );
    rbmenu->insertSeparator();
  }
  rbmenu->connectItem( rbmenu->insertItem(klocale->translate("Erase Part")), this, SLOT(deletePart()) );

  // rbmenu->connectItem( rbmenu->insertItem(klocale->translate("Test Output")), this, SLOT(testPart()) );

  show();
  repaint();
}

void QtPart::testPart() {
  cout << "offset: " << gPart()->gOffset() << endl << endl;
  // if (gPart()->gFirst() != 0) { cout << "first: " << gPart()->gFirst()->gPos() << ", last: " << gPart()->gLast()->gPos() << endl; }
  for (KbAtom * a = gPart()->gFirstAtom(); a!=0; a = a->gNext()) {
    cout << a->gPos() << " : ";
    if (a->isNote()) cout << "note" << endl;
    if (a->isAuxElement()) cout << "aux element" << endl;
    if (a->isMidiEvent()) cout << "midi event" << endl;
    if (a->isMasterEvent()) cout << "master event: " << ((KbMasterEvent*)a)->gTempo() << ", " << ((KbMasterEvent*)a)->gMeter0() << endl;
  }
}

void QtPart::userDefMenu(int n) {
  KbPartExtension * pe = qtmain->gMain()->extManager()->getExtension(n);
  if (pe!=0) pe->act(part);
}

QtPart::~QtPart() {

}

void QtPart::erase() {
  delete this;
}

void QtPart::instMenu(int entry) {
  part->sProgram(entry);

  // DOIT:((QtTrack*) part->gTrack()->gInterface())->sProgram(128);
  //  if (openScore!=0) openScore->scanvas->repaint( FALSE );
}

void QtPart::deletePart() {
  qtmain->msg("Part deleted");
  gPart()->deletePart();
}


void QtPart::paintEvent( QPaintEvent * pe ) {
  QLabel::paintEvent(pe);

  KbAtom * atom; unsigned long xx; unsigned long xx2; int left; int wid;
  double pixPerTick = qtmain->gPixPerTick();
  atom = gPart()->gFirstAtom();
  // if (atom) xx = atom->gPos().gPosTicks(); else xx = 0;
  xx = gPart()->gOffset().gPosTicks();
  atom = gPart()->gLastAtom();
  if (atom) { xx2 = atom->gPos().gPosTicks(); if (atom->isNote()) xx2 += ((KbNote*)atom)->gLen(); } else xx2 = 1536;
  left = pcanvas->gOffset()+int(xx*pixPerTick);
  wid = int(xx2*pixPerTick);
  if (wid<12) wid = 12;
  int n = gPart()->gTrack()->trackNum()+1;
  setGeometry(left,n*(qtmain->gTrackHeight()+1),wid,qtmain->gTrackHeight());

  int ymid = height()/2;
  QPainter painter;
  painter.begin(this);
  if (gPart()->gFirstAtom()) painter.setPen(blue); else painter.setPen(gray);

  if (qtmain->gPartShow()==0) { // show names
    painter.drawText(4,16,part->gTrack()->gName());
  }
  
  if (qtmain->gPartShow()==1) { // show events
    double pixPerTick = qtmain->gPixPerTick();
    for (KbAtom * n = part->gFirstAtom();n!=0;n=n->gNext()) {
      int xx = int(n->gPos().gPosTicks()*pixPerTick);
      int yy = 48;
      if (n->isNote()) { yy = int(((KbNote*)n)->gVel()*ymid*1.0/120); painter.setPen(blue); }
      else if (n->isMasterEvent()) { painter.setPen(red); }
      else { painter.setPen(green); }
      painter.drawLine(xx,ymid-yy,xx,ymid+yy);
    }
  }
  painter.end();
}


// *******************************************************************************
//
// Editors
// =======
//


void QtPart::scoreEdit() {
  //ScoreWindow * sc = new ScoreWindow("score", mw, this, pcanvas);
  //sc->show();
  QtScore * sc = new QtScore(part);
  sc->show();
}

void QtPart::drumEdit() {
  //DrumWindow * dc = new DrumWindow("drum", mw, this);
  //dc->show();
  QtDrum * dr = new QtDrum(part);
  dr->show();
}

void QtPart::pianoRollEdit() {
  QtPiano * pn = new QtPiano(part);
  pn->show();
}

void QtPart::eventEdit() {
  QtEvent * ev = new QtEvent(part);
  ev->show();
}

void QtPart::eventTimeEdit() {
  QtTEEdit * ev = new QtTEEdit(part);
  ev->show();
}

void QtPart::commentEdit() {
  QtCommentEdit * ev = new QtCommentEdit(part);
  ev->show();
}

void QtPart::waveEdit() {
  QtWaveEdit * ev = new QtWaveEdit(part);
  ev->show();
}



void QtPart::closeEditor() {
  // stuff that needs to be done when an editor closes goes here!
  repaint();
}


// *******************************************************************************
//
// Mouse Events
// ============
//


void QtPart::mousePressEvent( QMouseEvent * mouse ) {
  if (mouse->button()==LeftButton) {
    local_x = mapToParent(mouse->pos()).x();
    dx = 0;
    open = true;
  }
  if (mouse->button()==RightButton) {
    splitPoint = mapToParent(mouse->pos()).x();
    rbmenu->popup( mapToGlobal(mouse->pos()), 0 );
  }
}

void QtPart::mouseMoveEvent( QMouseEvent * mouse ) {
  QPoint p = mapToParent(mouse->pos());
  double pixPerTick = qtmain->gPixPerTick();
  int xx = p.x()-local_x;
  int dx1 = int(xx/pixPerTick); 
  if (dx<dx1) {
    part->sOffset(part->gOffset()+(dx1-dx)*1.0);
  }
  if ((dx>dx1)&&(part->gOffset()>(dx-dx1))) {
    part->sOffset(part->gOffset()-(dx-dx1)*1.0);
  }
  // part->snapOffset(qtmain->gMain()->gSnap());
  char * MSG = new char[40];
  int bar; int beat; int tick;
  part->gOffset().gBBT(bar,beat,tick,qtmain->gMain()->Master(),qtmain->gMain()->gMeter(0),qtmain->gMain()->gMeter(1));
  sprintf(MSG,"Part moved to %d. %d. %d\0",bar,beat,tick);
  qtmain->msg(MSG);
  delete[] MSG;
  
  pcanvas->repaint();
  
  dx=dx1;
  open = false;
}

void QtPart::mouseReleaseEvent( QMouseEvent * )
{
  if (open==false) {
    part->snapOffset(qtmain->gMain()->gSnap());
    char * MSG = new char[40];
    int bar; int beat; int tick;
    part->gOffset().gBBT(bar,beat,tick,qtmain->gMain()->Master(),qtmain->gMain()->gMeter(0),qtmain->gMain()->gMeter(1));
    sprintf(MSG,"Part moved to %d. %d. %d\0",bar,beat,tick);
    qtmain->msg(MSG);
    delete[] MSG;
    repaint();
  }
}


void QtPart::partCopy() {
  KbAtom * atom = part->gLastAtom();
  if (atom) {
    KbPosition os = part->gLastAtom()->gPos();
    if (atom->isNote()) os += ((KbNote*)atom)->gLen();
    KbPart * p = part->gTrack()->addPart(os);
    for (KbAtom * n=part->gFirstAtom();n!=0;n=n->gNext())
      p->appendNote(new KbNote(((KbNote*)n)->gFreq(),((KbNote*)n)->gVel(),((KbNote*)n)->gLen(),((KbNote*)n)->gPos(),((KbNote*)n)->gEnh()));
    p->snapOffset(qtmain->gMain()->gSnap());
  }
}

void QtPart::partGlue() {
  gPart()->glue();
  pcanvas->repaint();
}

void QtPart::partSplit() {
  unsigned long split = (unsigned long) ((splitPoint-pcanvas->gOffset())*1.0/qtmain->gPixPerTick());
  gPart()->split(split,qtmain->gMain()->gSnap());
  pcanvas->repaint();
}


void QtPart::partq() {
  part->quantize(part->gTrack()->gMain()->gSnap());
}

void QtPart::partql() {
  part->quantizeLength(part->gTrack()->gMain()->gSnap());
}

void QtPart::partfl() {
  part->fixedLength(part->gTrack()->gMain()->gSnap());
}



KbPart * QtPart::gPart() { return part; }

void QtPart::sPart(KbPart * p) { part = p; }

KbPart * QtPart::gNext() {
  return part->gNext();
}

void QtPart::sNext(KbPart * p) {
  part->sNext(p);
}




#endif
