#ifndef _QTPREFS_C_
#define _QTPREFS_C_

#include "qtPrefs.h"

QtPrefs::QtPrefs( QWidget * parent , const char * name )
    : QLabel( parent, name ), qtmain((QtMain*)parent)
{
  dialog = new QTabDialog();

  dialog->setFixedSize(220,340);

  // -------------------------------------
  //
  // MIDI SETUP
  //

  pref1 = new QWidget(dialog, "page 1");
  group1 = new QGroupBox("Click", pref1, "midisetup");
  group1->setGeometry(20,20,200,140);

  //  l0 = new QLabel("Click",group1);
  l11 = new QLabel("Beep:",group1);
  c11 = new QCheckBox(group1);
  //l12 = new QLabel("Use MIDI:",group1);
  //c12 = new QCheckBox(group1);
  l13 = new QLabel("Instrument No.",group1);
  s11 = new QSpinBox(0,127,1,group1);
  l14 = new QLabel("Volume",group1);
  s12 = new QSpinBox(0,127,1,group1);
  l15 = new QLabel("Precount",group1);
  s13 = new QSpinBox(0,8,1,group1);

  c11->setChecked(qtmain->gMain()->gBeepFlag()); connect(c11, SIGNAL(toggled(bool)), SLOT(updateC1(bool)));
  // c12->setChecked(qtmain->gMain()->gBeepMidi()); connect(c12, SIGNAL(toggled(bool)), SLOT(updateC2(bool)));
  s11->setValue(qtmain->gMain()->gClickInst()); connect(s11, SIGNAL(valueChanged(int)), SLOT(updateS1(int)));
  s12->setValue(qtmain->gMain()->gClickVol()); connect(s12, SIGNAL(valueChanged(int)), SLOT(updateS2(int)));
  s13->setValue(qtmain->gMain()->gPreBeats()); connect(s13, SIGNAL(valueChanged(int)), SLOT(updateS3(int)));

  l11->setGeometry(10,20,100,20);
  //  l12->setGeometry(10,40,100,20);
  l13->setGeometry(10,60,100,20);
  l14->setGeometry(10,80,100,20);
  l15->setGeometry(10,100,100,20);

  c11->setGeometry(110,20,60,20);
  // c12->setGeometry(110,40,60,20);
  s11->setGeometry(110,60,60,20);
  s12->setGeometry(110,80,60,20);
  s13->setGeometry(110,100,60,20);

  dialog->addTab(pref1, "MIDI Setup");

  // ---------------------------------
  //
  // Playback
  //
  
  pref2 = new QWidget(dialog, "page 2");
  l21 = new QLabel("Wait For Acoustic\nSignal Before Playing", pref2);
  c21 = new QCheckBox(pref2);

  c21->setChecked(qtmain->gMain()->gPlayWait()); connect(c21, SIGNAL(toggled(bool)), SLOT(updateC21(bool)));
  l21->setGeometry(10,40,140,40);
  c21->setGeometry(150,40,60,40);

  dialog->addTab(pref2, "playback");

  // ---------------------------------
  //
  // Desktop
  //
  
  pref3 = new QWidget(dialog, "page 3");

  g31 = new QButtonGroup(pref3);
  g31->setGeometry(20,20,200,140);
  r31 = new QRadioButton("show names",g31);
  r32 = new QRadioButton("show part events",g31);
  
  r31->setGeometry(10,20,140,20);
  r32->setGeometry(10,40,140,20);
  r31->setChecked(qtmain->gPartShow()==0);
  r32->setChecked(qtmain->gPartShow()==1);
  
  connect(g31,SIGNAL(clicked(int)),SLOT(updateG31(int)));

  dialog->addTab(pref3, "part appearence");


  dialog->show();
}

QtPrefs::~QtPrefs() {
  delete l11; delete l13; delete l14; delete l15;
  delete c11; delete s11; delete s12; delete s13;
  delete group1; delete pref1;
  delete l21; delete c21;
  delete pref2;
  delete dialog;
}

void QtPrefs::updateG31(int n) {
  cout << n << endl;
  qtmain->sPartShow(n);
}

void QtPrefs::updateC1(bool on) {
  qtmain->gMain()->sBeepFlag(on);
}

void QtPrefs::updateC2(bool on) {
  qtmain->gMain()->sBeepMidi(on);
}

void QtPrefs::updateS1(int n) {
  qtmain->gMain()->sClickInst(n);
}

void QtPrefs::updateS2(int n) {
  qtmain->gMain()->sClickVol(n);
}

void QtPrefs::updateS3(int n) {
  qtmain->gMain()->sPreBeats(n);
}

void QtPrefs::updateC21(bool on) {
  qtmain->gMain()->sPlayWait(on);
}






#endif
