#ifndef _QTSELFRAME_C_
#define _QTSELFRAME_C_

#include "qtSelFrame.h"
#include "qtEditor.h"
#include "kbPart.h"
#include "kbNote.h"
#include <qstring.h>

QtSelFrame::QtSelFrame( QWidget * parent, const char * name, KbMain * m )
  : QFrame(parent,name), main(m)
{
  top = new QLabel("--. -. --- ",this);
  top->setGeometry(0,1,72,10);
  top->setFont(QFont("courier",10));
  // top->setEnabled(FALSE);
  top->show();
  bottom = new QLabel("--. -. --- ",this);
  bottom->setGeometry(0,11,72,11);
  bottom->setFont(QFont("courier",10));
  // bottom->setEnabled(FALSE);
  bottom->show();
}

void QtSelFrame::setTop(int a, int b, int c) {
  QString qa; qa.setNum(a); QString qb; qb.setNum(b); QString qc; qc.setNum(c);
  top->setText(qc+QString(". ")+qb+QString(". ")+qa);
}

void QtSelFrame::setTop(KbPosition pos) {
  KbPart * master = main->Master();
  int m0 = main->gMeter(0);
  int m1 = main->gMeter(1);
  setTop(pos.gTicks(master,m0,m1),pos.gBeat(master,m0,m1),pos.gBar(master,m0,m1));
}

void QtSelFrame::setBottom(int a, int b, int c) {
  QString qa; qa.setNum(a); QString qb; qb.setNum(b); QString qc; qc.setNum(c);
  bottom->setText(qc+QString(". ")+qb+QString(". ")+qa);
}

void QtSelFrame::setBottom(KbPosition pos) {
  KbPart * master = main->Master();
  int m0 = main->gMeter(0);
  int m1 = main->gMeter(1);
  setBottom(pos.gTicks(master,m0,m1),pos.gBeat(master,m0,m1),pos.gBar(master,m0,m1));
}



// ***********************************************************************



NoteEdit::NoteEdit( int n, QWidget *parent=0, const char *name=0 )
  : QLineEdit( parent ), num(n), nb((Notebar*) parent)
{
  QColorGroup old = palette().normal();
  QColorGroup cg = QColorGroup ( old.foreground(), old.background(), old.light(), old.dark(), old.mid(), old.text(),
				 parent->backgroundColor() );
  setPalette( QPalette(cg, palette().disabled(), palette().active()) );
  setEnabled(FALSE);
  setFrame(FALSE);
}

void NoteEdit::focusInEvent ( QFocusEvent * fe )
{
  QLineEdit::focusInEvent( fe );
  setEnabled(TRUE);
  setFrame(TRUE);
}

void NoteEdit::focusOutEvent ( QFocusEvent * fe )
{
  setFrame(FALSE);
  QLineEdit::focusOutEvent( fe );
  this->repaint();
  switch (num) {
  case 0: nb->startEnter(); break;
  case 1: nb->lengthEnter(); break;
  case 2: nb->freqEnter(); break;
  case 3: nb->velEnter(); break;
  case 4: nb->chanEnter(); break;
  }
  // nb->editor->setFocus();
} 



void NoteEdit::enable() {
  setEnabled(TRUE);
  setText("");
}


// ***********************************************************************




PopLabel::PopLabel( QWidget * parent=0, const char *name=0)
  : QLabel((QLabel*)parent), editor(((Notebar*)parent)->editor), entry(0)
{
  KIconLoader *loader = kapp->getIconLoader();

  menu = new QPopupMenu( );
  menu->insertItem( loader->loadIcon( "sgnFlat2.xpm" ), -2+2);
  menu->insertItem( loader->loadIcon( "sgnFlat.xpm" ), -1+2);
  menu->insertItem( loader->loadIcon( "sgnNat.xpm" ), 0+2);
  //  menu->insertItem( klocale->translate("natural"), 3+2);
  menu->insertItem( loader->loadIcon( "sgnSharp.xpm" ), 1+2);
  menu->insertItem( loader->loadIcon( "sgnSharp2.xpm" ), 2+2);
  menu->setCheckable(true);
  menu->setItemChecked(0+2,TRUE);
  connect(menu,SIGNAL(activated(int)),SLOT(select(int)));
  setEnabled(FALSE);
}

void PopLabel::select( int num ) {
  menu->setItemChecked(entry+2,FALSE);
  entry = num-2;
  menu->setItemChecked(entry+2,TRUE);
  ((KbNote*)editor->selectedNote())->sEnh(entry);

  switch (entry) {
  case -2: setText(" bb"); break;
  case -1: setText(" b"); break;
  case 0: setText(" -"); break;
  case 1: setText(" #"); break;
  case 2: setText(" x"); break;
  }
  
  editor->repaint( FALSE );
}

void PopLabel::mousePressEvent ( QMouseEvent * mouse ) {
  menu->popup( mapToGlobal(mouse->pos()), 0 );
}


// -----------------------------------------------------------------



Notebar::Notebar( QWidget *parent=0, const char *name=0 )
  : KToolBar( parent ), editor( (QtEditor*) parent )
  // QFrame( parent ), editor( (QtEditor*) parent )
{
  // Position
  QLabel * lPos = new QLabel("start ",this);
  lPos->setGeometry(14,2,30,18);

  start = new NoteEdit( 0,this );
  start->setGeometry(44,2,82,18);
  connect(start,SIGNAL(returnPressed()),SLOT(startCF()));
  start->show();

  // Length
  QLabel * lLen = new QLabel("length ",this);
  lLen->setGeometry(128,2,40,18);

  length = new NoteEdit( 1,this );
  length->setGeometry(168,2,62,18);
  connect(length,SIGNAL(returnPressed()),SLOT(lengthCF()));
  length->show();

  // Pitch
  QLabel * lFreq = new QLabel("pitch ",this);
  lFreq->setGeometry(236,2,40,18);

  freq = new NoteEdit( 2,this );
  freq->setGeometry(276,2,62,18);
  connect(freq,SIGNAL(returnPressed()),SLOT(freqCF()));
  freq->show();

  // Velocity
  QLabel * lVel = new QLabel("vel ",this);
  lVel->setGeometry(344,2,40,18);

  vel = new NoteEdit( 3,this );
  vel->setGeometry(384,2,62,18);
  connect(vel,SIGNAL(returnPressed()),SLOT(velCF()));
  vel->show();

  // Enharmonic Shift
  QLabel * lEnh = new QLabel("enh.shft ",this);
  lEnh->setGeometry(450,2,50,18);
  lEnh->show();

  enhLabel = new PopLabel(this);
  enhLabel->setGeometry(500,2,20,18);
  enhLabel->show();

  // Channel
  QLabel * lChan = new QLabel("chn ",this);
  lChan->setGeometry(544,2,40,18);
  
  chan = new NoteEdit( 4,this );
  chan->setGeometry(584,2,62,18);
  connect(chan,SIGNAL(returnPressed()),SLOT(chanCF()));
  chan->show();

  //scanvas->showNoteInfoOff();
  setCursor(QCursor(0));

  //show();
}

void Notebar::startCF() { start->clearFocus(); }
void Notebar::lengthCF() { length->clearFocus(); }
void Notebar::freqCF() { freq->clearFocus(); }
void Notebar::velCF() { vel->clearFocus(); }
void Notebar::chanCF() { chan->clearFocus(); }

void Notebar::startEnter() {
  KbNote * sn = (KbNote*)editor->selectedNote();
  if (sn!=0) {
    const char * line = start->text();
    int x1 = atoi(line);
    for (;line[0]!='.';line++) {} line++; for (;line[0]==' ';line++) {}
    int x2 = atoi(line);
    for (;line[0]!='.';line++) {} line++; for (;line[0]==' ';line++) {}
    int x3 = atoi(line);
    int ticks = int(1536.0*editor->gPart()->gTime1()/editor->gPart()->gTime2());
    int pos = ticks*(x1-1) + ticks*(x2-1)/editor->gPart()->gTime1() + x3;
    if (pos>=0) {
      // cout << "pos: " << pos << ", " << editor->gLeftDelta() << endl;
      // KbNote * newNote = new KbNote(sn->gFreq(),sn->gVel(),sn->gLen(),pos,sn->gEnh(),sn->gChan());
      KbNote * newNote = (KbNote*) sn->copy();
      newNote->sPos(pos);
      editor->gPart()->deleteNote(sn);
      editor->selectNote(newNote);
      editor->gPart()->addNote(newNote);
    }
    // start->setFrame(FALSE);
    
    editor->repaint( FALSE );
  }
  
}

void Notebar::lengthEnter() {
  if (editor->selectedNote()!=0) {
    int l = atoi(length->text());
    ((KbNote*)editor->selectedNote())->sLen(l);
    // length->setFrame(FALSE);
    editor->repaint( FALSE );
  }
}

void Notebar::freqEnter() {
  if (editor->selectedNote()!=0) {
    const char * line = freq->text();
    int o = atoi(line+1);
    if (o==0) o = atoi(line+2);
    int f = 24;
    switch (line[0]) {
    case 'c': f = 24; break;
    case 'd': f = 26; break;
    case 'e': f = 28; break;
    case 'f': f = 29; break;
    case 'g': f = 31; break;
    case 'a': f = 33; break;
    case 'h': f = 35; break;
    case 'b': f = 35; break;
    case 'C': f = 24; break;
    case 'D': f = 26; break;
    case 'E': f = 28; break;
    case 'F': f = 29; break;
    case 'G': f = 31; break;
    case 'A': f = 33; break;
    case 'H': f = 35; break;
    case 'B': f = 35; break;
    }
    switch (line[1]) {
    case '#': f+=1; break;
    case 'b': f-=1; break;
    }
    f+=12*o;
    ((KbNote*)editor->selectedNote())->sFreq(f);
    // freq->setFrame(FALSE);
    editor->repaint( FALSE );
  }
  
}

void Notebar::velEnter() {
  if (editor->selectedNote()!=0) {
    int v = atoi(vel->text());
    ((KbNote*)editor->selectedNote())->sVel(v);
    // vel->setFrame(FALSE);
    editor->repaint( FALSE );
  }
}

void Notebar::chanEnter() {
  if (editor->selectedNote()!=0) {
    int c = 0;
    if (strcmp(chan->text(),"x")==0) c = -1;
    else c = atoi(chan->text());
    if ((c < -2)||(c > 15)) c = -1;
    ((KbNote*)editor->selectedNote())->sChan(c);
    editor->repaint( FALSE );
  }
}


void Notebar::setStart(int bar, int beat, int tick) {
  sprintf(position,"%3d.%2d.%3d",bar,beat,tick);
  start->enable();
  start->setText(position);
}

void Notebar::setLength(int len) {
  sprintf(lengths,"%d",len);
  length->enable();
  length->setText(lengths);
}

void Notebar::setPitch(int p) {
  int n = p%12;
  char ff;
  char sg;
  switch (n) {
  case 0: ff = 'c'; sg =' '; break;
  case 1: ff = 'c'; sg ='#'; break;
  case 2: ff = 'd'; sg =' '; break;
  case 3: ff = 'd'; sg ='#'; break;
  case 4: ff = 'e'; sg =' '; break;
  case 5: ff = 'f'; sg =' '; break;
  case 6: ff = 'f'; sg ='#'; break;
  case 7: ff = 'g'; sg =' '; break;
  case 8: ff = 'g'; sg ='#'; break;
  case 9: ff = 'a'; sg =' '; break;
  case 10: ff = 'a'; sg ='#'; break;
  case 11: ff = 'h'; sg =' '; break;
  }
  if (sg==' ') sprintf(pitch,"%c%d",ff,(int)p/12-2);
  else sprintf(pitch,"%c%c%d",ff,sg,(int)p/12-2);
  freq->enable();
  freq->setText(pitch);
}

void Notebar::setVelocity(int v) {
  sprintf(velocity,"%d",v);
  vel->enable();
  vel->setText(velocity);
}

void Notebar::setEnh(int e) {
  enhLabel->setEnabled(TRUE);
  enhLabel->setBackgroundMode(PaletteBackground);
  enhLabel->select(e); // +2, weil select der SLOT fuer das Popup ist, das von 0 bis 5 geht ;-)
}

void Notebar::setChan(int c) {
  if (c!=-1) sprintf(channel,"%d",c);
  else sprintf(channel,"x");
  chan->enable();
  chan->setText(channel);
}

void Notebar::clear() {
  start->setText(" --.-.--- ");
  start->setEnabled(FALSE);
  length->setText(" --- ");
  length->setEnabled(FALSE);
  freq->setText(" -- ");
  freq->setEnabled(FALSE);
  vel->setText(" -- ");
  vel->setEnabled(FALSE);
  enhLabel->setText(" - ");
  enhLabel->setEnabled(FALSE);
  chan->setText(" - ");
  chan->setEnabled(FALSE);
}

#endif
